#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <stdlib.h>
#include <sys/resource.h>

#define MAX_PSEUDONODE_SIZE 160
#define MAX_HASH_TABLE_SIZE 19131
#define MAX_STACK_SIZE 20000

#define INIT_ID      -1
#define NOBETANONEXT -1
#define NONEG        -1

#define EMPTY_LIST (ELM)NULL
#define GET_WFF(l) ((WFF)(l->elm))
#define GET_NODE(l) ((NODE)(l->elm))

#define WFF_SIZE sizeof(struct wff)
#define NODE_SIZE sizeof(struct node)
#define LIST_SIZE sizeof(struct list)

#define CONCAT(x,y) x ## y
#define ALLOC(t) (t)my_malloc(CONCAT(t,_SIZE))

enum {HEAD, ORDERED};

enum {ENOMEM=1,EPOPES, ETOPES, ELEX, EHASHFULL, ESTACKFULL, EUSAGE, EMAXPSN, EABTBL, ESWITCH};

typedef struct wff {
  int type; 
  int name;
  struct wff *left;
  struct wff *right;
  int ab_idx;
  char rhs;
  char marked;
} *WFF;

typedef struct alphabeta_entry {
  WFF f;
  struct alpha {
    int beta[2];
    int next;
  } alpha[2];
  int negf_idx;
  WFF negf;
} ALPHABETA_ENTRY;

typedef void *ELM;

typedef struct list {
  ELM elm;
  struct list *next;
} *LIST;

typedef struct node {
  int id;
  struct node *father;
  LIST outgoing;
  char old[MAX_PSEUDONODE_SIZE];
  char nxt[MAX_PSEUDONODE_SIZE];
  char *acceptance;
  int  loop_closed;
} *NODE;

typedef struct pseudonode {
  int id;
  NODE father;
  char new[MAX_PSEUDONODE_SIZE];
  char old[MAX_PSEUDONODE_SIZE];
  char nxt[MAX_PSEUDONODE_SIZE];
} PSEUDONODE;

typedef struct ext_node {
  NODE node;
  int counter;  
} EXT_NODE;

typedef struct stack {
  EXT_NODE ext_node[MAX_STACK_SIZE];
  int sp;
} STACK;

typedef EXT_NODE KEY;
typedef EXT_NODE HASH_TABLE_ELM;

typedef struct hash_table {
  int name;
  int counter;
  int collisions;
  HASH_TABLE_ELM elms[MAX_HASH_TABLE_SIZE];
} HASH_TABLE;
/***
  lb_ab.c 
  ***/
void generate_alphabeta_table(WFF f);
int load_alphabeta_table(WFF f);
int number_of_formulas(WFF f);
void clear_marks(WFF f);
void print_ab_table(FILE *fd);
void compute_negations(WFF f);
/***
  lb_aut.c 
  ***/
void l2b(WFF f);
void expand(PSEUDONODE pn);
void store_processed_node(PSEUDONODE *pn);
int completely_processed(PSEUDONODE *pn);
int contradiction(PSEUDONODE *pn, WFF f);
int is_redundant(PSEUDONODE *pn, WFF f);
void move_from_new_to_old(PSEUDONODE *pn, int i);
PSEUDONODE compute_next(NODE n);
int SI(WFF f, PSEUDONODE *pn);
int belongs(WFF f, NODE n);
void compute_acceptance_conditions(NODE n);
void new_unprocessed_node(NODE n);
NODE next_unprocessed_node(void);
int nodes_match(NODE n, PSEUDONODE *pn);
NODE new_node(PSEUDONODE *pn);
PSEUDONODE init_pseudonode(WFF f);
float get_time(struct rusage t);
/***
  lb_hash.c
***/
void init_hash_table(HASH_TABLE *ht, int i);
void clear_hash_table(HASH_TABLE *ht);
int get_hash_size(HASH_TABLE *ht);
int hash(KEY *k);
void mark(HASH_TABLE *ht, EXT_NODE en);
int marked(HASH_TABLE *ht, EXT_NODE en);
/***
  lb_list.c
***/
LIST init_list(ELM elm);
LIST first_elm(LIST l);
unsigned int get_list_size(LIST l);
LIST insert_into_list(LIST l, ELM elm, int mode);
LIST remove_from_list(LIST l, ELM e);
int list_is_empty(LIST l);
int lists_match(LIST l1, LIST l2);
LIST nl(void);
/***
  lb_main.c
***/
int main(int argc, char **argv);
void non_fatal(int err_code);
void fatal(int err_code);
void print_res(int r, int g, int t, int s, float tm);
void init_global_structures();
/***
  lb_malloc.c 
  ***/
char *my_malloc(int n);
char *generic_malloc(int n);
void print_max_mem(void);
/***
  lb_paut.c
***/
void print_automaton(FILE *fd, LIST l);
void print_state(FILE *fd, NODE s);
void print_pseudonode(FILE *fd, PSEUDONODE *pn);
void print_statistics(void);
/***
  lb_pwff.c
***/
void print_op(FILE *fd, int op);
void print_wff(FILE *fd, WFF f);
void print_wffs(FILE *fd, char *f);
/***
  lb_src.c
***/
int search(void);
int exists_unmarked_successor(EXT_NODE x, HASH_TABLE *ht, EXT_NODE *y, int dfs);
int accepting(EXT_NODE x);
int is_successor(EXT_NODE x, EXT_NODE v);
int ext_nodes_match(EXT_NODE en1, EXT_NODE en2);
void save_counters(HASH_TABLE *ht1, HASH_TABLE *ht2);
/***
  lb_stack.c
***/
void init_stack(STACK *s);
int stack_is_empty(STACK *s);
void push_into_stack(STACK *s, EXT_NODE en);
EXT_NODE pop_from_stack(STACK *s);
EXT_NODE top_of_stack(STACK *s);
/***
  lb_wff.c
***/
WFF lookup(int type, WFF l, WFF r);
void compute_until(WFF f);
void compute_until_aux(WFF f);
int is_commutative(int op);
int dual(int op);
WFF nnf(WFF f);
WFF neg(WFF f);
int is_atom(WFF f);
int is_literal(WFF f);
int is_elementary(WFF f);
WFF new_wff(int t, int n, WFF l, WFF r);
WFF nw(void);
/***
  lb.y
***/
void yyerror(char *);
int yywrap(void);

extern WFF parse_tree, true, false;
extern LIST automaton, node_list, sub_wffs, until_formulas;
extern NODE init;
extern ALPHABETA_ENTRY *ab_table;
extern int ab_idx;
extern int optimize, slug, verbose;
extern int n_wff, n_list, n_generic_malloc;
extern int n_graph, n_trans, n_until, n_dfs;
extern char *formula;
extern struct rusage start_time, stop_time;
extern float elapsed_time;
