%{
#include "lb.h"
#include "y.tab.h"

#ifdef FROMCMDLINE
#undef input()
#undef unput()
#define input() (*formula++)
#define unput(c) (*--formula = c)
#endif

%}
%%
[ \n\t]                 ;
"--".*\n                ;
"/\\"                   return(AND);
"\\/"                   return(OR);
"->"                    return(IMPLIES);
"<->"                   return(EQUIV);
"~"                     return(NOT);
"F"                     return(EVENTUALLY);
"G"                     return(GLOBALLY);
"U"                     return(UNTIL);
"V"                     return(NOT_UNTIL);
"X"                     return(NEXT);
"("                     return(LPAR);
")"                     return(RPAR);
"true"                  { 
                             yylval.node = true;
                             return(TRUE);
                        }
"false"                 { 
                             yylval.node = false;
                             return(FALSE);
                        }
p[0-9]+                 { 
                             yylval.node = new_wff(ATOM, atoi(yytext+1), NULL, NULL);
                             return(ATOM);
                        }
.                       {
                             fatal(ELEX);
                        }
%%




