%{
#include "lb.h"

WFF parse_tree;
%}

%union { WFF node;}

/*
  all of the terminal grammar symbols (tokens recognized by the lexical analyzer) 
  note: all binary operators associate from left to right ops are listed from lowest
  to highest priority 
*/

%token <node> ATOM FALSE TRUE
%token LPAR RPAR
%right IMPLIES EQUIV UNTIL NOT_UNTIL
%left OR
%left AND 
%nonassoc NOT 
%nonassoc NEXT
%nonassoc EVENTUALLY
%nonassoc GLOBALLY

/* all nonterminals return a parse tree node */
%type <node> begin ltl

%start begin
%%
begin            : ltl {parse_tree = $1; $$=$1;}
                 ;
ltl              : TRUE                {$$ = true; }
                 | FALSE               {$$ = false; }
                 | ATOM                {$$ = lookup(ATOM, $1, NULL); }
                 | ltl AND ltl         {$$ = lookup(AND, $1, $3); }
                 | ltl OR  ltl         {$$ = lookup(OR, $1, $3); }
                 | ltl IMPLIES ltl     {$$ = lookup(OR, neg($1), $3); }
                 | ltl EQUIV ltl       {$$ = lookup(OR, lookup(AND, $1, $3), lookup(AND, neg($1), neg($3))); }
                 | EVENTUALLY ltl      {$$ = (($2 == true) ? $2 : lookup(UNTIL, true, $2)); }
                 | ltl UNTIL ltl       {$$ = (($3 == true) ? $3 : lookup(UNTIL, $1, $3)); }
                 | GLOBALLY ltl        {$$ = lookup(NOT_UNTIL, false, $2); }
                 | ltl NOT_UNTIL ltl   {$$ = lookup(NOT_UNTIL, $1, $3); }
                 | NOT ltl             {$$ = neg($2); }
                 | NEXT ltl            {$$ = lookup(NEXT, $2, NULL); }
                 | LPAR ltl RPAR       {$$ = $2; }
                 ;
%%

void yyerror(char *s)
{
  printf("%s\n", s);
}

int yywrap()
{
  return 1;
}






