#include "lb.h"
#include "y.tab.h"

ALPHABETA_ENTRY *ab_table;
int ab_idx=0;

void generate_alphabeta_table(WFF f)
{
  int nf;
  WFF notf=nnf(neg(f));

  if (verbose) {
    fprintf(stdout, "formula as negated ann nnf-ed: ");
    print_wff(stdout, notf);
    fprintf(stdout, "\n");
  }
  
  clear_marks(f);
  clear_marks(notf);
  nf=number_of_formulas(f)+number_of_formulas(notf);
  ab_table=(ALPHABETA_ENTRY*)generic_malloc((1+nf) * (sizeof(struct alphabeta_entry)));
  clear_marks(f);
  clear_marks(notf);
  load_alphabeta_table(f);
  load_alphabeta_table(notf);
  if (nf > MAX_PSEUDONODE_SIZE || ab_idx > MAX_PSEUDONODE_SIZE || ab_idx > nf) {
    fatal(EMAXPSN); 
  }
  compute_negations(f);
  if (verbose)
    print_ab_table(stdout); 
}

int load_alphabeta_table(WFF f)
{
  int this_ab_idx;
  int a0b0=NOBETANONEXT,a0b1=NOBETANONEXT,a0n=NOBETANONEXT;
  int a1b0=NOBETANONEXT,a1b1=NOBETANONEXT,a1n=NOBETANONEXT;

  if (!f) 
    fatal(EABTBL);
  if (f->marked)
    return f->ab_idx;

  
  switch (f->type) {
  case FALSE:
  case TRUE:
  case ATOM:
  case NOT:
    break;
  case NEXT:
    a0n  = load_alphabeta_table(f->left);
    break;
  case OR:
    a0b0 = load_alphabeta_table(f->left);
    a1b0 = load_alphabeta_table(f->right);
    break;
  case AND:
    a0b0 = load_alphabeta_table(f->left);
    a0b1 = load_alphabeta_table(f->right);
    break;
  case UNTIL:
    a0b0 = load_alphabeta_table(f->left);
    a1b0 = load_alphabeta_table(f->right);
    a0n  = ab_idx;
    break;
  case NOT_UNTIL:
    a0b0 = load_alphabeta_table(f->right);
    a1b0 = load_alphabeta_table(f->right);
    a1b1 = load_alphabeta_table(f->left);
    a0n  = ab_idx;
    break;
  }
  
  f->marked = 1;
  f->ab_idx = this_ab_idx = ab_idx++;
  ab_table[this_ab_idx].f = f;
  ab_table[this_ab_idx].alpha[0].beta[0] = a0b0;
  ab_table[this_ab_idx].alpha[0].beta[1] = a0b1;
  ab_table[this_ab_idx].alpha[0].next    = a0n;
  ab_table[this_ab_idx].alpha[1].beta[0] = a1b0;
  ab_table[this_ab_idx].alpha[1].beta[1] = a1b1;
  ab_table[this_ab_idx].alpha[1].next    = a1n;
  ab_table[this_ab_idx].negf_idx = NONEG;
  ab_table[this_ab_idx].negf = NULL;
  
  return this_ab_idx;
}

void compute_negations(WFF f)
{
  int i,j;
  WFF negf;

  for (i=0; i<ab_idx; i++) 
    if (!ab_table[i].negf) {
      ab_table[i].negf=nnf(neg(ab_table[i].f));
      for (j=0; j<ab_idx; j++)
	if (ab_table[j].f == ab_table[i].negf) {
	  ab_table[i].negf_idx=j;
	  ab_table[j].negf_idx=i;
	  ab_table[j].negf=ab_table[i].f;
	  break;
	}
      if (j==ab_idx)
	fatal(EABTBL);
    }
}

int number_of_formulas(WFF f)
{
  if (!f || f->marked)
    return 0;
  f->marked=1;
  if (is_literal(f))
    return 1;
  return  1 + number_of_formulas(f->left) + number_of_formulas(f->right);
}

void clear_marks(WFF f)
{
  if (f) {
    f->marked=0;
    clear_marks(f->left);
    clear_marks(f->right);
  }
}

void print_ab_table(FILE *fd)
{
  int i;

  fprintf(fd, "AlphaBeta table:\n");
  for (i=0; i<ab_idx; i++) {
    fprintf(fd, "%d [", i);
    print_wff(fd, ab_table[i].f);
    fprintf(fd, "]\n\ta1=(b1=%d, b2=%d, next=%d), a2=(b1=%d, b2=%d, next=%d) -- neg=%d\n", 
	    ab_table[i].alpha[0].beta[0],
	    ab_table[i].alpha[0].beta[1],
	    ab_table[i].alpha[0].next,
	    ab_table[i].alpha[1].beta[0],
	    ab_table[i].alpha[1].beta[1],
	    ab_table[i].alpha[1].next,
	    ab_table[i].negf_idx);
  }
}
