#include "lb.h"
#include "y.tab.h"

#define CLEAR_PSEUDONODE(pn)      memset(&pn,0,sizeof(struct pseudonode))

LIST automaton, node_list;
NODE init;
int n_graph=0, n_trans=0;
struct rusage start_time, stop_time;
float elapsed_time;

static int pseudonode_id=0;

void l2b(WFF f)
{
  PSEUDONODE pn = init_pseudonode(f);
  
  getrusage(RUSAGE_SELF, &start_time);

  init=new_node(&pn);
  new_unprocessed_node(init);  
  while (!list_is_empty(node_list)) {
    pn = compute_next(next_unprocessed_node());
    if (verbose)
      fprintf(stderr, "pushing a new pseudonode [%d] for successors of state [%d]\n", pn.id, pn.father->id);
    expand(pn);
  }

  getrusage(RUSAGE_SELF, &stop_time);

  elapsed_time=get_time(stop_time)-get_time(start_time);
}

#define LEFT   ab_table[i].f->left->ab_idx
#define RIGHT  ab_table[i].f->right->ab_idx
#define F      ab_table[i].f->ab_idx
#define ADD(f) if (!pn.old[f]) pn.new[f]=1 

void expand(PSEUDONODE pn)
{
  int i; /* first unprocessed formula */
  char old_left;
  char old_right;

  if (verbose) {
    fprintf(stderr, "pushing a new pseudonode [%d] from pseudonode [%d]\n", pseudonode_id, pn.id);
  }
  
  pn.id=pseudonode_id++;

  if (verbose) {
    print_pseudonode(stderr,&pn);
  }
  
  if ((i=completely_processed(&pn)) < 0)
    store_processed_node(&pn);
  else {    

    pn.new[i]=0;
    
    if (verbose) {
      fprintf(stderr, "processing ");
      print_wff(stderr, ab_table[i].f);
      fprintf(stderr, "\n");
    }     
    
    if (contradiction(&pn,ab_table[i].f)) {
      /* just discard the contradictory pseudonode */
      if (verbose) {
	fprintf(stderr, "contradiction in pseudonode %d\n", pn.id);
	print_pseudonode(stderr, &pn);
      } 
    } else if (is_redundant(&pn, ab_table[i].f)) {
      /* just discard the redundant formula and keep processing the remaining part */
      if (ab_table[i].f != true) pn.old[i]=1;
      if (verbose) {
	fprintf(stderr, "formula is redundant\n");
      }
      expand(pn);
    } else {
      pn.old[i]=1;
      switch (ab_table[i].f->type) {
      case FALSE:
	fatal(ESWITCH);
	break;
      case NEXT:
	pn.nxt[LEFT] = 1;
      case TRUE:
      case ATOM:
      case NOT:
	expand(pn);
	break;
      case OR:
	old_left = pn.new[LEFT];
	ADD(LEFT);
	expand(pn);
	pn.new[LEFT] = old_left;
	ADD(RIGHT);
	expand(pn);
	break;
      case AND:
	ADD(LEFT);
	ADD(RIGHT);
	expand(pn);
	break;
      case UNTIL:
	old_right = pn.new[RIGHT];
	ADD(RIGHT);
	expand(pn);
	pn.new[RIGHT] = old_right;
	ADD(LEFT);
	pn.nxt[F] = 1;
	expand(pn);
	break;
      case NOT_UNTIL:
	old_left  = pn.new[LEFT];
	old_right = pn.new[RIGHT];
	ADD(RIGHT);
	ADD(LEFT);
	expand(pn);
	pn.new[LEFT]  = old_left;
	pn.new[RIGHT] = old_right;
	ADD(RIGHT);
	pn.nxt[F] = 1;
	expand(pn);
	break;
      default:
	fatal(ESWITCH);
	break;
      }
    }
  }
}

void store_processed_node(PSEUDONODE *pn)
{
  LIST aux=automaton;
  NODE n;
  unsigned int b=get_list_size(pn->father->outgoing);
  int i;

  for (i=0; i<ab_idx && !slug; i++)
    if (!(is_elementary(ab_table[i].f) || !optimize && (ab_table[i].f->type == UNTIL || ab_table[i].f->rhs)))
      pn->old[i]=0;

  if (verbose) {
    if (pn->father == init)
      fprintf(stderr, "pseudonode %d (initial) has been completely processed\n", pn->id);
    else
      fprintf(stderr, "pseudonode %d (successor of %d) has been completely processed\n", pn->id, pn->father->id);
  }
  
  for (aux=aux->next; aux && !nodes_match(GET_NODE(aux), pn); aux=aux->next);
  if (aux) {
    insert_into_list(pn->father->outgoing, GET_NODE(aux), ORDERED);
    if (verbose) 
      fprintf(stderr, "and has already been generated as state [%d]\n", GET_NODE(aux)->id);
  } else {
    n_graph++;
    /*printf("STORING %d\n", pn->id);*/
    n = new_node(pn);
    insert_into_list(pn->father->outgoing, n, ORDERED); 
    insert_into_list(automaton, n, HEAD);
    new_unprocessed_node(n);
    if (verbose) {
      fprintf(stderr, "and is a new state\n"); 
      print_state(stderr, n);
    }
  }	
  if (pn->father != init && b != get_list_size(pn->father->outgoing))
    n_trans++;
}

int completely_processed(PSEUDONODE *pn)
{
  int i;
  for (i=0; i<ab_idx && !(pn->new[i]); i++);
  if (i==ab_idx) 
    return -1;
  else 
    return i;
}

int contradiction(PSEUDONODE *pn, WFF f)
{
  if (f == true || slug && !is_literal(f))
    return 0;
  if (f == false)
    return 1;

  if (!optimize) 
    return pn->old[ab_table[f->ab_idx].negf_idx];
  else 
    return SI(ab_table[f->ab_idx].negf,pn);
}      

int is_redundant(PSEUDONODE *pn, WFF f)
{
  if (slug) return 0;

  if (!optimize) {
    if (f->type == UNTIL && (pn->old[f->right->ab_idx] || pn->new[f->right->ab_idx]) ||
	f->type == NOT_UNTIL && ((pn->old[f->left->ab_idx]  || pn->new[f->left->ab_idx]) && 
				 (pn->old[f->right->ab_idx] || pn->new[f->right->ab_idx])))
      return 1;
    else
      return 0;
  } else
    return (SI(f,pn) && (f->type != UNTIL || SI(f->right,pn)));
}

PSEUDONODE compute_next(NODE n)
{
  PSEUDONODE pn;
  int i;

  CLEAR_PSEUDONODE(pn);
  pn.id=pseudonode_id++;
  pn.father=n;
  for (i=0; i<ab_idx; i++)
    pn.new[i]=n->nxt[i];
  return pn;
}

int SI(WFF f, PSEUDONODE *pn)
{
  switch (f->type) {
  case FALSE:
    return 0;
    break;
  case TRUE:
    return 1;
    break;
  case ATOM:
  case NOT:
  case NEXT:
    return pn->old[f->ab_idx] || pn->new[f->ab_idx];
    break;
  case OR:
    return (pn->old[f->ab_idx] || pn->new[f->ab_idx]) || (SI(f->left, pn) || SI(f->right, pn));
    break;
  case AND:
    return (pn->old[f->ab_idx] || pn->new[f->ab_idx]) || (SI(f->left, pn) && SI(f->right, pn));
    break;
  case UNTIL:
    return ((pn->old[f->ab_idx] || pn->new[f->ab_idx]) || 
	    (SI(f->right, pn) || (SI(f->left, pn) && pn->nxt[f->ab_idx])));
    break;
  case NOT_UNTIL:
    return ((pn->old[f->ab_idx] || pn->new[f->ab_idx]) || 
	    (SI(f->right, pn) && (SI(f->left, pn) || pn->nxt[f->ab_idx])));
    break;
  default:
    fatal(ESWITCH);
    break;
  }
}

int belongs(WFF f, NODE n)
     /*** ITS THE SAME OF SI, SUBSTITUTE EVENTUALLY ***/
{
  if (!optimize)
    return n->old[f->ab_idx];
  else { 
    switch (f->type) {
    case FALSE:
      return 0;
      break;
    case TRUE:
      return 1;
      break;
    case ATOM:
    case NOT:
    case NEXT:
      return n->old[f->ab_idx];
      break;
    case OR:
      return belongs(f->left, n) || belongs(f->right, n);
      break;
    case AND:
      return belongs(f->left, n) && belongs(f->right, n);
      break;
    case UNTIL:
      return belongs(f->right, n) || (belongs(f->left, n) && n->nxt[f->ab_idx]);
      break;
    case NOT_UNTIL:
      return belongs(f->right, n) && (belongs(f->left, n) || n->nxt[f->ab_idx]);
      break;
    default:
      fatal(ESWITCH);
      break;
    }
  }
}

void compute_acceptance_conditions(NODE n)
{
  LIST aux;
  int i;
  
  for (i=0, aux=until_formulas->next; aux; aux=aux->next, i++)
    if (!belongs(GET_WFF(aux), n) || belongs(GET_WFF(aux)->right, n))
      n->acceptance[i]=1;
    else 
      n->acceptance[i]=0;
}
      
void new_unprocessed_node(NODE n)
{
  insert_into_list(node_list, n, HEAD);
}

NODE next_unprocessed_node(void)
{ 
  return GET_NODE(remove_from_list(node_list, GET_NODE(first_elm(node_list))));
}

int nodes_match(NODE n, PSEUDONODE *pn)
{
  int i;
  for (i=0; i<ab_idx && n->old[i]==pn->old[i] && n->nxt[i]==pn->nxt[i]; i++);
  return (i==ab_idx ? 1 : 0);
}

NODE new_node(PSEUDONODE *pn)
{
  int i;
  NODE aux=ALLOC(NODE);

  aux->id=pn->id;
  aux->father=pn->father;
  aux->outgoing=init_list(EMPTY_LIST);
  for (i=0; i<ab_idx; i++) {
    aux->old[i]=pn->old[i];
    aux->nxt[i]=pn->nxt[i];
  }
  aux->acceptance=generic_malloc(n_until);
  if (aux->id!=INIT_ID)
    compute_acceptance_conditions(aux);
  else
    for (i=0;i<n_until;i++)
      aux->acceptance[i]=0;
  aux->loop_closed=0;
  return aux;
}

PSEUDONODE init_pseudonode(WFF f)
{
  PSEUDONODE pn;

  CLEAR_PSEUDONODE(pn);
  pn.id=INIT_ID;
  pn.father=NULL;
  pn.nxt[f->ab_idx]=1;
  return pn;
}

float get_time(struct rusage t)
{
  return ((float)(t.ru_utime.tv_sec + t.ru_stime.tv_sec)) + ((float)(t.ru_utime.tv_usec + t.ru_stime.tv_usec))/1000000;
}
