#include "lb.h"

static int l, h, i;

void init_hash_table(HASH_TABLE *ht, int n)
{
  for (i=0; i < MAX_HASH_TABLE_SIZE; ht->elms[i++].node=NULL);
  ht->name=n;
  ht->counter=0;
  ht->collisions=0;
}

int get_hash_size(HASH_TABLE *ht)
{
  return ht->counter;
}

int hash(KEY *key)
{	
  static int h_aux;
  char *k=(char *)key;
  
  h_aux=0;
  for (i=0; i<sizeof(KEY); i++) {	
    h_aux += *k++;
    h_aux <<= 1;
    if (h_aux&(MAX_HASH_TABLE_SIZE+1))
      h_aux |= 1;
  }
  return h_aux&MAX_HASH_TABLE_SIZE;
}

void mark(HASH_TABLE *ht, EXT_NODE k)
{
  for (l=h=hash(&k); ht->elms[h].node && !ext_nodes_match(ht->elms[h], k) && 
	 ((h+1)%MAX_HASH_TABLE_SIZE != l); h=(h+1)%MAX_HASH_TABLE_SIZE);
  if (ext_nodes_match(ht->elms[h], k))
    return;
  if ((h+1)%MAX_HASH_TABLE_SIZE == l) 
    fatal(EHASHFULL);
  ht->elms[h]=k;
  ht->counter++;
  if (h>=l)
    ht->collisions +=h-l;
  else
    ht->collisions +=(MAX_HASH_TABLE_SIZE - l) + h;

  if (verbose) {
    fprintf(stdout, "stored node [%d,%d] in hash_table%d[%d]\n", k.node->id, k.counter, ht->name, h);
  }
}

int marked(HASH_TABLE *ht, EXT_NODE k)
{
  for (l=h=hash(&k); ht->elms[h].node && !ext_nodes_match(ht->elms[h], k) && 
	 l!=(h+1)%MAX_HASH_TABLE_SIZE; h=(h+1)%MAX_HASH_TABLE_SIZE);

  if (verbose) {
    if (ext_nodes_match(ht->elms[h], k)) {
      fprintf(stdout, "found node [%d,%d] in hash_table%d[%d]\n", k.node->id, k.counter, ht->name, h);
    }
  }
  return (ext_nodes_match(ht->elms[h], k));
}
