#include "lb.h"

int n_list=0;

LIST init_list(ELM elm)
{
  LIST aux=nl();
  aux->elm=(ELM)0; /* this pointer field is used for storing the number of elements in the list */
  aux->next=(LIST)NULL;
  if (elm)
    insert_into_list(aux, elm, HEAD);
  return aux;
}

LIST first_elm(LIST l)
{
  return l->next;
}

unsigned int get_list_size(LIST l)
{
  return (unsigned int)l->elm;
}

LIST insert_into_list(LIST l, ELM elm, int mode)
{
  LIST aux, l_aux=l;
  
  for (; mode == ORDERED && l->next && l->next->elm < elm; l=l->next);
  if (mode == HEAD || !(l->next) || l->next->elm > elm) {
    l_aux->elm=(ELM)(++(unsigned int)(l_aux->elm)); /* increment the number of elms */
    aux=nl();
    aux->elm=elm;
    aux->next=l->next;
    l->next=aux;
  }
  return l->next;
}

LIST remove_from_list(LIST l, ELM e)
{
  LIST aux, l_aux=l;
  for (; l->next && l->next->elm != e; l=l->next);
  aux=l->next;
  if (l->next) {
    l_aux->elm=(ELM)(--(unsigned int)(l_aux->elm)); /* decrement the number of elms */
    l->next=l->next->next;
  }
  return aux;
}

int list_is_empty(LIST l)
{
  return (l->next==(LIST)NULL);
}

int lists_match(LIST l1, LIST l2)
{
  for (; l1 && l2 && l1->elm == l2->elm; l1=l1->next, l2=l2->next);
  return (!l1 && !l2);
}

LIST nl(void)
{
  n_list++;
  return ALLOC(LIST);
}
