#include "lb.h"
#include "y.tab.h"

int optimize=0, short_errors=0, slug=0, verbose=0; 
char *formula=NULL;

int main(int argc, char **argv) 
{
  int res;

  for (--argc, argv++; argc; argc--, argv++) {
    if (argv[0][0]=='-') {
      argv[0]++; 
      switch (argv[0][0]) {
      case 'o': 
	optimize=1; 
	slug=0;
	break;
      case 'e': 
	short_errors=1; 
	break;
      case 's': 
	slug=1;
	optimize=0;
	break;
      case 'v': 
	verbose=1; 
	break;
      default: 
	fatal(EUSAGE);
	break;
      }
    } else {
      formula = generic_malloc(strlen(argv[0])+1);
      strcpy(formula, argv[0]);
    }
  }
#ifdef FROMCMDLINE
  if (!formula) 
    fatal(EUSAGE);
#endif
  
  print_max_mem();

  init_global_structures();
  if (yyparse()==0) {

    if (verbose) {
      fprintf(stderr, "formula as parsed: ");
      print_wff(stderr, parse_tree);
      fprintf(stderr, "\n");
    }

    parse_tree = nnf(parse_tree);

    if (verbose) {
      fprintf(stderr, "formula as nnf-ed: ");
      print_wff(stderr, parse_tree);
      fprintf(stderr, "\n");
    }

    generate_alphabeta_table(parse_tree);
    compute_until(parse_tree);
    l2b(parse_tree);
    
    if (verbose)
      print_automaton(stderr, automaton);

    res=search();

  }
  if (!short_errors)
    printf("\t%s\n", res?"true":"false");
  else
    print_res(res, n_graph, n_trans, n_dfs, elapsed_time);
  return res;
}

#define E(msg) fprintf(stdout, msg); fprintf(stdout, "\n"); break;

void non_fatal(int err_code)
{
  if (short_errors) {
    err_code = -err_code;
    print_res(err_code, err_code, err_code, err_code, err_code);
  } else {
    switch (err_code) {
    case ENOMEM: E("no more memory");
    case EPOPES: E("popping from empty stack");
    case ETOPES: E("topping from empty stack"); 
    case ELEX:   E("syntax error");
    case EHASHFULL: E("hash table full");
    case ESTACKFULL: E("stack full");
    case EUSAGE: E("usage: lb [-osv] \"formula\"\n\to: optimize\n\ts: optimize search\n\tv: verbose");
    case EMAXPSN: E("too many sub-formulas (increase MAX_PSEUDONODE)");
    case EABTBL: E("load_alphabeta_table_aux: unexpected empty node or negation not found");
    case ESWITCH: E("unexpected value in switch");
    }
  }
}

void fatal(int err_code)
{
  non_fatal(err_code);
  exit(-1);
}

void print_res(int r, int g, int t, int s, float tm)
{
  fprintf(stdout, "%d %d %d %d %f\n", r, g, t, s, tm);
}

void init_global_structures()
{
  false = new_wff(FALSE, 'F', NULL, NULL);
  true  = new_wff(TRUE, 'T', NULL, NULL);
  sub_wffs = init_list(EMPTY_LIST);
  automaton = init_list(EMPTY_LIST);
  node_list = init_list(EMPTY_LIST);
  until_formulas = init_list(EMPTY_LIST);
}





