#include "lb.h"

#define MAX_MEMORY 20000000

char base[MAX_MEMORY];
int free_mem=MAX_MEMORY;

char *my_malloc(int n)
{
  if (free_mem < n) 
    fatal(ENOMEM);
  
  free_mem -= n;
  memset(base+free_mem, 0, n);
  return base+free_mem;
}

int n_generic_malloc=0;

char *generic_malloc(int n)
{
  n += n%sizeof(int) ? sizeof(int) - n%sizeof(int) : 0; 
  n_generic_malloc +=n;
  return my_malloc(n);
}

void print_max_mem(void)
{
  fprintf(stderr, "MAX MEMORY: %d bytes\n", MAX_MEMORY);
}
