#include "lb.h"

void print_automaton(FILE *fd, LIST l)
{
  int f;
  LIST aux;

  fprintf(fd, "\n\nAUTOMATON:\n");  
  fprintf(fd, "\nInitial states: ");
  for (f=0, aux=init->outgoing->next; aux; f=1, aux=aux->next) 
    fprintf(fd, "%s%d", (f ? ", " : ""), GET_NODE(aux)->id);
  fprintf(fd, "\n\n");
  for (l=l->next; l; l=l->next) {
    print_state(fd, GET_NODE(l));
    fprintf(fd, "\n");
  }
  /*  print_statistics(fd);*/
}

void print_state(FILE *fd, NODE s)
{
  LIST l;
  int f, i;
  
  fprintf(fd, "State [%d]:", s->id);
  fprintf(fd, "\nOld\t: ");
  print_wffs(fd, s->old);
  fprintf(fd, "\nNxt\t: ");
  print_wffs(fd, s->nxt);
  fprintf(fd, "\nSucc\t: ");
  for (f=0, l=s->outgoing->next; l; f=1, l=l->next)     
    fprintf(fd, "%s%d", (f  ? ", "  : ""), GET_NODE(l)->id);
  fprintf(fd,"\nAcc\t: ");
  for (f=0,i=0; i<n_until; i++) 
    if (s->acceptance[i]) {
      fprintf(fd, "%s%d", (f ? ", ": ""), i);
      f=1;
    }
  fprintf(fd, "\n");
}

void print_pseudonode(FILE *fd, PSEUDONODE *pn)
{
  fprintf(fd, "pseudonode [%d]:", pn->id);
  fprintf(fd, "\nNew\t: ");
  print_wffs(fd, pn->new);
  fprintf(fd, "\nOld\t: ");
  print_wffs(fd, pn->old);
  fprintf(fd, "\nNxt\t: ");
  print_wffs(fd, pn->nxt);
  fprintf(fd, "\n");
}

/*
void print_statistics(FILE *fd)
{
  fprintf(stderr, "STATISTICS:\n");
  fprintf(stderr, "%d nodes [%d bytes] have been generated for the formula.\n", n_formula, n_formula*WFF_SIZE); 
  fprintf(stderr, "%d nodes [%d bytes] have been generated for the automaton.\n", n_graph, n_graph*NODE_SIZE);
  fprintf(stderr, "%d nodes [%d bytes] have been generated for the lists.\n", n_list, n_list*LIST_SIZE);
  fprintf(stderr, "%d states [%d bytes] have been generated.\n", s, s*NODE_SIZE);
  fprintf(stderr, "%d transitions.\n", n_trans);
  fprintf(stderr, "%d acceptance conditions.\n", n_until);
  fprintf(stderr, "\n");
}
*/
