#include "lb.h"
#include "y.tab.h"

void print_op(FILE *fd, int op)
{
  switch (op) {
  case NOT: fprintf(fd, "~"); break;
  case NEXT: fprintf(fd, "X"); break;
  case AND: fprintf(fd, " /\\ "); break;
  case OR: fprintf(fd, " \\/ "); break;
  case UNTIL: fprintf(fd, " U "); break;
  case NOT_UNTIL: fprintf(fd, " V "); break;
  }
}

void print_wff(FILE *fd, WFF f)
{
  /*  fprintf(fd,"%d",f->ab_idx);
  return;*/
  switch (f->type) {
  case TRUE: 
    fprintf(fd,"T");
    break;
  case FALSE: 
    fprintf(fd,"F");
    break;
  case ATOM: 
    fprintf(fd, "p%d", f->name);
    break;
  case NOT:
  case NEXT:
    print_op(fd, f->type);
    fprintf(fd, "%s", (is_atom(f->left) ? "" : "("));
    print_wff(fd, f->left);
    fprintf(fd, "%s", (is_atom(f->left) ? "" : ")"));
    break;
  case AND: 
  case OR: 
  case UNTIL: 
  case NOT_UNTIL: 
    fprintf(fd, "%s", (is_atom(f->left) ? "" : "("));
    print_wff(fd, f->left);
    fprintf(fd, "%s", (is_atom(f->left) ? "" : ")"));
    print_op(fd, f->type);
    fprintf(fd, "%s", (is_atom(f->right) ? "" : "("));
    print_wff(fd, f->right);
    fprintf(fd, "%s", (is_atom(f->right) ? "" : ")"));
    break;
  }
}

void print_wffs(FILE *fd, char *wffs)
{
  int f, i;

  f=0;
  for (i=0; i<ab_idx; i++)
    if (wffs[i]) {
      if (f) 
	fprintf(fd, ", ");
      else
	f=1;
      print_wff(fd, ab_table[i].f);
    }
}
