#include "lb.h"

int n_dfs;

int search(void)
{
  HASH_TABLE M1;
  HASH_TABLE M2;
  STACK S1;
  STACK S2;
  EXT_NODE s0;
  EXT_NODE x;
  EXT_NODE v;
  EXT_NODE y;
  EXT_NODE w;

  init_stack(&S1);
  s0.node=init;
  s0.counter=0;
  push_into_stack(&S1, s0);
  init_stack(&S2);
  init_hash_table(&M1,1);
  init_hash_table(&M2,2);
  
  while (!stack_is_empty(&S1)) {
    x=top_of_stack(&S1);
    if (verbose) 
      fprintf(stdout, "processing node [%d,%d] from the S1\n", x.node->id, x.counter);
    if (exists_unmarked_successor(x, &M1, &y, 1)) {
      mark(&M1, y);
      push_into_stack(&S1, y);
    } else {
      x=pop_from_stack(&S1);
      if (accepting(x) && !marked(&M2,x) && x.node != init) {
	if (verbose) 
	  fprintf(stdout, "and pushing into S2\n");

	mark(&M2, x);
	push_into_stack(&S2,x);
	while (!stack_is_empty(&S2)) {
	  v=top_of_stack(&S2);	  
	  if (is_successor(x,v)) {
	    save_counters(&M1, &M2);
	    return 1;
	  }
	  if (!exists_unmarked_successor(v, &M2, &w, 2)) {
	    v=pop_from_stack(&S2);
	  } else {	    
	    mark(&M2, w);
	    push_into_stack(&S2, w);
	  }
	}
      }
    }
  }
  save_counters(&M1, &M2);
  return 0;
}

int exists_unmarked_successor(EXT_NODE x, HASH_TABLE *ht, EXT_NODE *y, int dfs)
{
  EXT_NODE aux;
  int change_counter=x.node->acceptance[x.counter];
  LIST child;

  if (n_until && change_counter)
    aux.counter = (x.counter+1)%n_until;
  else
    aux.counter = x.counter;
  
  for (child=x.node->outgoing->next; child; child=child->next) {
    aux.node = GET_NODE(child);
    if (!marked(ht, aux)) {
      *y=aux;
      if (verbose) {
	fprintf(stdout, "unprocessed child node [%d,%d] of node [%d,%d] was found\n", 
		y->node->id, y->counter, x.node->id, x.counter);
      }
      return 1;
    }
  }
  if (verbose) {
    fprintf(stdout, "node [%d,%d] completely processed, popping from S%d\n", 
	    x.node->id, x.counter, dfs);
  }
  return 0;
}

int accepting(EXT_NODE x)
{
  return (n_until==0 || x.counter == 0 && x.node->acceptance[0]);
}

int is_successor(EXT_NODE x, EXT_NODE v) 
{
  EXT_NODE aux;
  LIST child;
  int change_counter=v.node->acceptance[v.counter];

  if (n_until && change_counter)
    aux.counter = (v.counter+1)%n_until;
  else
    aux.counter = v.counter;
  
  for (child=v.node->outgoing->next; child; child=child->next) {
    aux.node=GET_NODE(child);
    if (ext_nodes_match(aux,x))
      break;
  }
  return (child ? 1 : 0);
}

int ext_nodes_match(EXT_NODE en1, EXT_NODE en2)
{
  return (en1.node == en2.node && en1.counter ==  en2.counter);
}

void save_counters(HASH_TABLE *ht1, HASH_TABLE *ht2)
{
  n_dfs=get_hash_size(ht1)+get_hash_size(ht2);
}
