#include "lb.h"

void init_stack(STACK *s)
{
  s->sp=0;
}

int stack_is_empty(STACK *s)
{
  return (s->sp == 0);
}

void push_into_stack(STACK *s, EXT_NODE en)
{
  if (s->sp == MAX_STACK_SIZE)
    fatal(ESTACKFULL);

  s->ext_node[s->sp++]=en;
} 

EXT_NODE pop_from_stack(STACK *s)
{
  if (s->sp == 0)
    fatal(EPOPES);

  s->sp--;
  return s->ext_node[s->sp];
}

EXT_NODE top_of_stack(STACK *s)
{
  if (s->sp == 0) 
    fatal(ETOPES);

  return s->ext_node[s->sp-1];
}
