
#include "lb.h"
#include "y.tab.h"

WFF true, false;
LIST sub_wffs, until_formulas;
int n_wff=0, n_until=0;

WFF lookup(int type, WFF l, WFF r)
{
  LIST aux;
  
  switch (type) {
  case ATOM: 
    for (aux=sub_wffs->next; aux; aux=aux->next) 
      if (GET_WFF(aux)->type == ATOM && GET_WFF(aux)->name == l->name) 
	break;
    if (!aux) aux=insert_into_list(sub_wffs, l, ORDERED);
    break;
  case AND:
  case OR:
  case NEXT:
  case UNTIL:
  case NOT_UNTIL:
    for (aux=sub_wffs->next; aux; aux=aux->next) 
      if (GET_WFF(aux)->type == type && 
	  (GET_WFF(aux)->left == l && GET_WFF(aux)->right == r || 
	   is_commutative(type) && GET_WFF(aux)->left == r && GET_WFF(aux)->right == l)) 
	break;
    if (!aux) aux=insert_into_list(sub_wffs, new_wff(type, 0, l, r), ORDERED);
    break;
  case NOT: 
    for (aux=sub_wffs->next; aux; aux=aux->next) 
      if (GET_WFF(aux)->type == NOT && GET_WFF(aux)->left == l) 
	break;
    if (!aux) aux=insert_into_list(sub_wffs, new_wff(NOT, 0, l, NULL), ORDERED);
    break;
  }
  return GET_WFF(aux);
}

void compute_until(WFF f)
{
  clear_marks(f);
  compute_until_aux(f);
}

void compute_until_aux(WFF f)
{
  if (!f) return;
  if (f->marked) 
    return;

  f->marked=1;
  if (f->type == UNTIL) {
    ++n_until;
    insert_into_list(until_formulas, f, ORDERED);
    f->right->rhs = 1;
  }
  compute_until_aux(f->left);
  compute_until_aux(f->right);
}

int is_commutative(int op)
{
  return (op == AND || op == OR);
}

int dual(int op)
{
  switch (op) {
  case NEXT:
    return NEXT;
    break;
  case AND:
    return OR;
    break;
  case OR:
    return AND;
    break;
  case UNTIL:
    return NOT_UNTIL;
    break;
  case NOT_UNTIL:
    return UNTIL;
    break;
  default:
    fatal(ESWITCH);
    break;
  }
}

WFF nnf(WFF f)
{
  if (!f)
    return f;
  else if (is_atom(f)) 
    return f;
  else if (f->type != NOT) 
    return lookup(f->type, nnf(f->left), nnf(f->right));
  else { 
    f=f->left;
    if (is_atom(f))
      return neg(f);
    else 
      return lookup(dual(f->type), nnf(neg(f->left)), nnf(neg(f->right)));
  }
}

WFF neg(WFF f)
{ 
  if (!f)
    return f;
  else if (f == false)
    return true;
  else if (f == true)
    return false;
  else if (f->type == NOT) 
    return f->left;
  else 
    return lookup(NOT, f, NULL);
}

int is_atom(WFF f)
{
  return (f->type == ATOM || f->type == TRUE || f->type == FALSE);
}

int is_literal(WFF f)
{
  return (is_atom(f) || f->type == NOT);
}

int is_elementary(WFF f)
{
  return (is_literal(f) || f->type == NEXT);
}

WFF new_wff(int t, int n, WFF l, WFF r)
{
  WFF aux=nw();

  aux->type = t;
  aux->name = n;
  aux->left = l;
  aux->right = r;
  aux->rhs = 0;
  aux->marked = 0;
  return aux;
}

WFF nw(void)
{
  n_wff++;
  return ALLOC(WFF);
}
