package model.fish;

import model.fish.display.NarrowFishDisplay;
import model.ILambda;
import sysModel.fish.AFish;
import sysModel.env.IBlockedCommand;
import sysModel.env.IOpenCommand;

import java.awt.*;

/**
 * Class for a darter fish.
 *
 * @author Mathias G. Ricken
 */
public class DarterFish extends AFish {
    /**
     * Create a new darter fish.
     */
    public DarterFish(Color fishColor) {
        super(fishColor, NarrowFishDisplay.Singleton);
    }

    /**
     * Carry out movement behavior for the fish.
     */
    protected void move() {
        // attempt to move forward
        tryMoveFwd(new IBlockedCommand() {
            public Object apply(Object param) {
                // could not move forward at all
                // turn PI radians
                turnRight(Math.PI);
                return null;
            }
        },
            new IOpenCommand() {
                public Object apply(Object param) {
                    // the field ahead is open, move
                    ((ILambda)param).apply(null);
                    // attempt to move forward again
                    tryMoveFwd(new IBlockedCommand() {
                        public Object apply(Object param) {
                            // could not move forward any more
                            // do nothing
                            return null;
                        }
                    },
                        new IOpenCommand() {
                            public Object apply(Object param) {
                                // second field ahead is open, move
                                ((ILambda)param).apply(null);
                                return null;
                            }
                        });
                    return null;
                }
            });
    }
}
