package controller;

import java.awt.*;

/**
 * Adapter to connect the display and the model.
 *
 * @author Mathias Ricken
 */
public interface IDisplayAdapter {
    /**
     * Draw model in this region. The graphics object has been set up so that (0,0) represents the top left and
     * (100,100) the bottom right corner.
     *
     * @param g    graphics object
     * @param comp the component to drawFish on
     * @param p1   top left edge of the region
     * @param p2   bottom right edge of the region
     */
    void draw(Graphics2D g, Component comp, Point.Double p1, Point.Double p2);

    /**
     * Get size of the display.
     *
     * @return size of the display in model coordinate units.
     */
    Dimension getDisplaySize();

    /**
     * The action to be executed if the display should return home.
     *
     * @param sa scroll adapter
     */
    void returnHome(IScrollAdapter sa);

    /**
     * Ask the model where to scroll, given where the user has scrolled. If the environment just acts like a normal
     * panal, it should return pos without modification. If the environment recenters, it should return a position in
     * the middle of the pan area. All coordinates are in model coordinate units.
     *
     * @param pos position where the user scrolled to
     *
     * @return position where the environment wants the view to be
     *
     * @see IDisplayAdapter#getPanDelta
     */
    Point.Double getViewPosition(Point.Double pos);

    /**
     * Ask the model how much to pan, given where the user scrolled. If the environment just acts like a normal panal,
     * it should return (0,0). If the environment recenters, it should return delta without modification. All
     * coordinates are in model coordinate units.
     *
     * @param delta how far the user scrolled
     *
     * @return how far the panel should scroll
     *
     * @see IDisplayAdapter#getViewPosition
     */
    Point.Double getPanDelta(Point.Double delta);
}
