package controller;

import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.ISecurityAdapter;
import sysModel.env.AEnvFactory;

import java.awt.*;

/**
 * Adapter to connect the environment controls and the model.
 *
 * @author Mathias Ricken
 */
public interface IEnvAdapter {
    /**
     * Load environment from file.
     *
     * @param filename filename
     *
     * @return true if successful
     */
    boolean loadEnvironment(String filename);

    /**
     * Save environment to file.
     *
     * @param filename filename
     *
     * @return true if successful
     */
    boolean saveEnvironment(String filename);

    /**
     * Create environment from factory.
     *
     * @param factory factory
     *
     * @return true if successful
     */
    boolean createEnvironment(AEnvFactory factory);

    /**
     * Set the seed command. This command gets executed before a new environment is created or loaded.
     *
     * @param seedCmd command to set
     */
    void setSeedLambda(ILambda seedCmd);

    /**
     * Edit a field.
     *
     * @param p      mouse coordinates
     * @param button mouse button pressed
     */
    void edit(Point.Double p, int button);

    /**
     * Get a tool tip description for a specific place in the environment.
     *
     * @param p mouse coordinates
     *
     * @return tool tip text
     */
    String getToolTipText(Point.Double p);

    /**
     * Return an array of environment class names to be loaded at startup.
     *
     * @return array of class names
     */
    String[] getEnvironmentClassNames();

    /**
     * Return an array of fish class names to be loaded at startup.
     *
     * @return array of class names
     */
    String[] getFishClassNames();

    /**
     * Return the factory to make commands for the simulation driver.
     *
     * @return command factory
     */
    ICmdFactory getCmdFactory();

    /**
     * Return the security adapter.
     *
     * @return security adapter
     */
    ISecurityAdapter getSecurityAdapter();
}
