package controller;

import model.ILambda;

/**
 * Adapter to connect the simulation toolbar and the simulation.
 *
 * @author Mathias Ricken
 */
public interface ISimAdapter {
    /**
     * Make a simulation step.
     */
    void step();

    /**
     * Start simulation.
     */
    void start();

    /**
     * Stop simulation.
     */
    void stop();

    /**
     * Change the simulation speed.
     *
     * @param speed simulation speed
     */
    void setSpeed(int speed);

    /**
     * Set simulation start command. This command gets called before the simulation starts.
     *
     * @param startCmd start command
     */
    void setStartLambda(ILambda startCmd);

    /**
     * Set simulation iteration command. This command gets called after the simulation finishes a step.
     *
     * @param itCmd start command
     */
    void setIterationLambda(ILambda itCmd);
}
