package lrs.visitor;

import lrs.IAlgo;
import lrs.LRStruct;

/**
 * Return the length of the list.
 *
 * @author Mathias Ricken
 */
public class GetLength implements IAlgo {
    /// singleton instance
    public static final GetLength Singleton = new GetLength();

    /// private singleton ctor
    private GetLength() {
    }

    /**
     * Operates on an empty LRStruct host, given an input object.
     *
     * @param host an empty LRStruct.
     * @param inp  unused
     *
     * @return length of the list
     */
    public Object emptyCase(LRStruct host, Object inp) {
        return new Integer(0);
    }

    /**
     * Operates on a non-empty LRStruct host, given an input object.
     *
     * @param host a non-empty LRStruct.
     * @param inp  unused
     *
     * @return an length of the list
     */
    public Object nonEmptyCase(LRStruct host, Object inp) {
        return host.getRest().execute(new IAlgo() {
            /**
             * Operates on an empty LRStruct host, given an input object.
             *
             * @param host an empty LRStruct.
             * @param inp  input object needed by this IAlgo.
             *
             * @return an appropriate output object.
             */
            public Object emptyCase(LRStruct host, Object inp) {
                return inp;
            }

            /**
             * Operates on a non-empty LRStruct host, given an input object.
             *
             * @param host a non-empty LRStruct.
             * @param inp  input object needed by this IAlgo.
             *
             * @return an appropriate output object.
             */
            public Object nonEmptyCase(LRStruct host, Object inp) {
                return host.getRest().execute(this, new Integer(((Integer)inp).intValue() + 1));
            }
        }, new Integer(1));
    }
}
