package lrs.visitor;

import lrs.IAlgo;
import lrs.LRStruct;

/**
 * Remove all occurances of the item specified as input, if found.
 *
 * @author Mathias Ricken
 */
public class Remove implements IAlgo {
    /// singleton instance
    public static final Remove Singleton = new Remove();

    /// private singleton ctor
    protected Remove() {
    }

    /**
     * Operates on an empty LRStruct host, given an input object.
     *
     * @param host an empty LRStruct.
     * @param inp  item to remove.
     *
     * @return null
     */
    public Object emptyCase(LRStruct host, Object inp) {
        return null;
    }

    /**
     * Operates on a non-empty LRStruct host, given an input object.
     *
     * @param host a non-empty LRStruct.
     * @param inp  item to remove.
     *
     * @return null
     */
    public Object nonEmptyCase(LRStruct host, Object inp) {
        if (host.getFirst() == inp) {
            host.removeFront();
            // recur on this element (used to be rest)
            return host.execute(this, inp);
        }
        else {
            // recur on rest
            return host.getRest().execute(this, inp);
        }
    }
}
