package model;

import java.util.Random;

/**
 * Singleton random number generator.
 *
 * @author Mathias G. Ricken
 */
public final class RandNumGenerator extends Random {
    /**
     * Singleton instance.
     */
    private static RandNumGenerator _instance = null;

    /**
     * Seed value.
     */
    private int _seed = 0;

    /**
     * Return singleton instance.
     *
     * @return singleton instance
     */
    public static synchronized RandNumGenerator instance() {
        if (null == _instance) {
            _instance = new RandNumGenerator();
        }
        return _instance;
    }

    /**
     * Overridden set seed method.
     *
     * @param seed new seed
     */
    public void setSeed(int seed) {
        super.setSeed(seed);
        _seed = seed;
    }

    /**
     * Return seed.
     *
     * @return seed
     */
    public int getSeed() {
        return _seed;
    }

    /**
     * Private singleton constructor.
     */
    private RandNumGenerator() {
    }
}

