package model.fish;

import model.fish.display.CircleFishDisplay;
import model.ILambda;
import sysModel.fish.AFish;
import sysModel.env.IBlockedCommand;
import sysModel.env.IOpenCommand;

import java.awt.*;

/**
 * A fish that swims around in a circle.
 *
 * @author Mathias Ricken
 */
public class CircleFish extends AFish {
    /**
     * Create a new circle fish.
     *
     * @param fishColor color of the fish
     */
    public CircleFish(Color fishColor) {
        super(fishColor, CircleFishDisplay.Singleton);
    }

    /**
     * Carry out movement behavior for the fish.
     */
    protected void move() {
        // attempt to move forward
        tryMoveFwd(new IBlockedCommand() {
            public Object apply(Object param) {
                // the field ahead is blocked, turn around
                turnRight(Math.PI);
                return null;
            }
        },
            new IOpenCommand() {
                public Object apply(Object param) {
                    // the field ahead is open, move
                    ((ILambda)param).apply(null);
                    // turn 10 degrees to the right
                    turnRight(Math.PI / 18);
                    return null;
                }
            });

    }
}
