package model.fish;

import model.fish.display.RoundFishDisplay;
import model.RandNumGenerator;
import model.ILambda;
import sysModel.fish.AFish;
import sysModel.env.IBlockedCommand;
import sysModel.env.IOpenCommand;

import java.awt.*;

import lrs.LRStruct;
import lrs.visitor.GetLength;
import lrs.visitor.GetNth;

/**
 * Class for a generic fish.
 *
 * @author Mathias G. Ricken
 */
public class GenericFish extends AFish {
    /**
     * Create a new generic fish.
     *
     * @param fishColor color of the fish
     */
    public GenericFish(Color fishColor) {
        super(fishColor, RoundFishDisplay.Singleton);
    }

    /**
     * Carry out movement behavior for the fish.
     */
    protected void move() {
        final LRStruct moveLambdas = new LRStruct();

        // turn PI/2 radians to the left and attempt to move forward
        turnLeft();

        final IBlockedCommand blocked3 = new IBlockedCommand() {
            public Object apply(Object param) {
                int size = ((Integer)moveLambdas.execute(GetLength.Singleton, null)).intValue();

                if (0 != size) {
                    // pick random move command
                    Integer randnum = new Integer(RandNumGenerator.instance().nextInt(size));
                    ILambda cmd = (ILambda)moveLambdas.execute(GetNth.Singleton, randnum);

                    // apply that command
                    cmd.apply(null);
                }
                else {
                    // turn back PI/2 radians to the left
                    turnLeft();
                }
                return null;
            }
        };

        final IBlockedCommand blocked2 = new IBlockedCommand() {
            public Object apply(Object param) {
                // turn PI/2 radians to the right and attempt to move forward
                turnRight();
                return tryMoveFwd(blocked3,
                    new IOpenCommand() {
                        public Object apply(Object param) {
                            // the field to the right is open
                            moveLambdas.insertFront(param);
                            return blocked3.apply(null);
                        }
                    });
            }
        };

        final IBlockedCommand blocked1 = new IBlockedCommand() {
            public Object apply(Object param) {
                // turn PI/2 radians to the right and attempt to move forward
                turnRight();
                return tryMoveFwd(blocked2,
                    new IOpenCommand() {
                        public Object apply(Object param) {
                            // the field straight ahead is open
                            moveLambdas.insertFront(param);
                            return blocked2.apply(null);
                        }
                    });
            }
        };


        tryMoveFwd(blocked1,
            new IOpenCommand() {
                public Object apply(Object param) {
                    // the field to the left is open
                    moveLambdas.insertFront(param);
                    return blocked1.apply(null);
                }
            });
    }
}
