package model.fish;

import model.fish.display.ImageFishDisplay;
import model.RandNumGenerator;
import model.ILambda;
import sysModel.fish.AFish;
import sysModel.env.IBlockedCommand;
import sysModel.env.IOpenCommand;

import java.awt.*;

/**
 * A fish that moves like a knight in chess.
 *
 * @author Mathias Ricken
 */
public class KnightFish extends AFish {
    /**
     * Make a new knight fish.
     *
     * @param fishColor color of the fish
     */
    public KnightFish(Color fishColor) {
        super(fishColor, new ImageFishDisplay("knight.gif", 0));
    }

    /**
     * Carry out movement behavior for the fish.
     */
    protected void move() {
        int target = RandNumGenerator.instance().nextInt(8);
        int turns = target / 2; // number of 90 degree turns
        turnRight(turns * Math.PI / 2.0);
        final boolean oneOverToLeft = (0 == (target % 2)); // true if the "one over" step goes to the left, false if to the right

        // try to make the first step forward
        tryMoveFwd(new IBlockedCommand() {
            public Object apply(Object param) {
                // if blocked, do nothing
                return null;
            }
        }, new IOpenCommand() {
            public Object apply(Object param) {
                // if open, move
                ((ILambda)param).apply(null);

                // try to make the second step forward
                return tryMoveFwd(new IBlockedCommand() {
                    public Object apply(Object param) {
                        // if blocked, do nothing
                        return null;
                    }
                }, new IOpenCommand() {
                    public Object apply(Object param) {
                        // if open, move
                        ((ILambda)param).apply(null);

                        // if over to the left...
                        if (oneOverToLeft) {
                            // ...turn left
                            turnLeft();
                        }
                        else {
                            // ...else turn right
                            turnRight();
                        }

                        // try to make the step over
                        return tryMoveFwd(new IBlockedCommand() {
                            public Object apply(Object param) {
                                // if blocked, do nothing
                                return null;
                            }
                        }, new IOpenCommand() {
                            public Object apply(Object param) {
                                // if open, move
                                ((ILambda)param).apply(null);

                                return null;
                            }
                        });
                    }
                });
            }
        });
    }
}
