package model.fish;

import model.fish.display.RoundFishDisplay;
import model.RandNumGenerator;

import java.awt.*;

/**
 * Class for a slow fish.
 *
 * @author Mathias G. Ricken
 */
public class SlowFish extends GenericFish {
    /**
     * Probability that this slow fish moves.
     */
    private double _probOfMoving = 1.0f / 5.0f;

    /**
     * Create a new slow fish.
     *
     * @param fishColor color of the fish
     */
    public SlowFish(Color fishColor) {
        super(fishColor);
    }

    /**
     * Carry out movement behavior for the fish.
     */
    protected void move() {
        if (RandNumGenerator.instance().nextDouble() < _probOfMoving) {
            // slow fish attempts to move like super class
            super.move();
        }
    }
}
