package sysModel;

/**
 * Adapter to connect environments and security manager.
 *
 * @author Mathias Ricken
 */
public interface ISecurityAdapter {
    /**
     * Set the protection flag.
     *
     * @param b true if actions are to be protected
     */
    void setProtected(boolean b);

    /**
     * Get the thread group the fish are run in.
     * @return fish thread group
     */
    ThreadGroup getFishThreadGroup();

    /**
     * Return the class loader that checks fish classes for potential security violations.
     * @return class loader
     */
    ClassLoader getClassLoader();

    /**
     * Handle an exception that was caught during the simulation.
     * @param t caught exception
     */
    void handleException(Throwable t);
}
