package sysModel.classFile.attributes;

import sysModel.classFile.attributes.visitors.IAttributeVisitor;
import sysModel.classFile.code.instructions.LineNumberTable;
import sysModel.classFile.constantPool.AUTFPoolInfo;
import sysModel.classFile.constantPool.ConstantPool;

/**
 * Represents an unknown attribute in a class file.
 *
 * @author Mathias Ricken
 */
public class UnknownAttributeInfo extends AAttributeInfo {
    /**
     * Constructor.
     *
     * @param name attribute name
     * @param data attribute data
     * @param cp   constant pool
     *
     * @throws ClassFormatError
     */
    public UnknownAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) throws ClassFormatError {
        super(name, data, cp);
    }

    /**
     * Execute a visitor on this attribute.
     *
     * @param visitor visitor
     * @param param   visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public <R, D> R execute(IAttributeVisitor<R, D> visitor, D param) {
        return visitor.unknownCase(this, param);
    }

    /**
     * Adjust program counter values contained in this attribute, starting at startPC, by adding deltaPC to them.
     *
     * @param startPC program counter to start at
     * @param deltaPC change in program counter values
     */
    public void adjustPC(short startPC, short deltaPC) {
        // nothing to do
    }

    /**
     * Translate the program counter values contained in this attribute from an old line number table to a new one.
     *
     * @param index      critical point (insertion or deletion point)
     * @param deltaIndex delta value to add to all old line numbers greater than the critical point
     * @param oldLnt     old line number table
     * @param newLnt     new line number table
     */
    public void translatePC(short index, short deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
        // nothing to do
    }

    /**
     * Creates and returns a copy of this object.
     */
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /**
     * Returns the name of the attribute as it appears in the class file.
     *
     * @return name of the attribute.
     */
    public static String getAttributeName() {
        throw new Error("This is not an actual attribute. Should never query for it!");
    }
}
