package sysModel.classFile.attributes.visitors;

import sysModel.classFile.attributes.*;

/**
 * An attribute visitor in which all cases call an abstract default method.
 *
 * @author Mathias Ricken
 */
public abstract class ADefaultAttributeVisitor <R, D> implements IAttributeVisitor<R, D> {
    /**
     * Abstract default case.
     *
     * @param host  host
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public abstract R defaultCase(AAttributeInfo host, D param);

    /**
     * Case for SourceFile attribute.
     *
     * @param host  attribute
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return vakue
     */
    public R sourceFileCase(SourceFileAttributeInfo host, D param) {
        return defaultCase(host, param);
    }

    /**
     * Case for an unknown attribute.
     *
     * @param host  attribute
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return vakue
     */
    public R unknownCase(UnknownAttributeInfo host, D param) {
        return defaultCase(host, param);
    }

    /**
     * Case for Code attribute.
     *
     * @param host  attribute
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return vakue
     */
    public R codeCase(CodeAttributeInfo host, D param) {
        return defaultCase(host, param);
    }
}
