package sysModel.classFile.attributes.visitors;

import sysModel.classFile.attributes.*;

/**
 * A visitor that operates on attributes.
 *
 * @author Mathias Ricken
 */
public interface IAttributeVisitor <R, D> {
    /**
     * Case for SourceFile attribute.
     *
     * @param host  attribute
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return vakue
     */
    R sourceFileCase(SourceFileAttributeInfo host, D param);

    /**
     * Case for Code attribute.
     *
     * @param host  attribute
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return vakue
     */
    R codeCase(CodeAttributeInfo host, D param);

    /**
     * Case for an unknown attribute.
     *
     * @param host  attribute
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return vakue
     */
    R unknownCase(UnknownAttributeInfo host, D param);}
