package sysModel.classFile.code.instructions;

import sysModel.classFile.code.Opcode;
import junit.framework.TestCase;

import java.util.NoSuchElementException;

/**
 * @author Mathias Ricken
 */
public class LineNumberTableTest extends TestCase {
    protected final byte[] TEST_CODE = new byte[]{
        Opcode.ALOAD_0, // 0
        Opcode.IFEQ, 0, 0, // 1
        Opcode.GOTO, 0, 0, // 4
        Opcode.GOTO_W, 0, 0, 0, 0, // 7
        Opcode.ALOAD, 0, // 12
        Opcode.WIDE, Opcode.ALOAD, 0, 0, // 14
        Opcode.IINC, 0, 0, // 18
        Opcode.WIDE, Opcode.IINC, 0, 0, 0, 0, // 21
        Opcode.TABLESWITCH, /*default*/(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xf1, /*low*/0, 0, 0, 5, /*high*/0, 0, 0, 7,
        /*5*/(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xf3, /*6*/(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xf7, /*7*/(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xfa, // 27
        Opcode.LOOKUPSWITCH, /*pad*/ 0, 0, 0, /*default*/(byte)0xff, (byte)0xff, (byte)0xff, (byte)0xe7, /*n*/0, 0, 0, 2, /*key*/0, 0, 0, 0,
        /*offset*/0, 0, 0, 0, /*key*/ 0, 0, 0, 1, /*offset*/ (byte)0xff, (byte)0xff, (byte)0xff, (byte)0xcc, // 52
        Opcode.RETURN // 80
    };

    public void testPCtoLineNo() {
        LineNumberTable lnt = new LineNumberTable(TEST_CODE);

        assertEquals("Wrong line number", 0, lnt.getLineNumber(0));
        assertEquals("Wrong line number", 1, lnt.getLineNumber(1));
        assertEquals("Wrong line number", 2, lnt.getLineNumber(4));
        assertEquals("Wrong line number", 3, lnt.getLineNumber(7));
        assertEquals("Wrong line number", 4, lnt.getLineNumber(12));
        assertEquals("Wrong line number", 5, lnt.getLineNumber(14));
        assertEquals("Wrong line number", 6, lnt.getLineNumber(18));
        assertEquals("Wrong line number", 7, lnt.getLineNumber(21));
        assertEquals("Wrong line number", 8, lnt.getLineNumber(27));
        assertEquals("Wrong line number", 9, lnt.getLineNumber(52));
        assertEquals("Wrong line number", 10, lnt.getLineNumber(80));
        assertEquals("Wrong line number", 11, lnt.getLineNumber(81));

        try {
            lnt.getLineNumber(82);
            fail("Should have thrown NoSuchElementException");
        }
        catch(NoSuchElementException e) {
            // pass
        }
        catch(Throwable t) {
            fail("Should have thrown NoSuchElementException");
        }
    }

    public void testLineNoToPC() {
        LineNumberTable lnt = new LineNumberTable(TEST_CODE);

        assertEquals("Wrong line number", 0, lnt.getPC(0));
        assertEquals("Wrong line number", 1, lnt.getPC(1));
        assertEquals("Wrong line number", 4, lnt.getPC(2));
        assertEquals("Wrong line number", 7, lnt.getPC(3));
        assertEquals("Wrong line number", 12, lnt.getPC(4));
        assertEquals("Wrong line number", 14, lnt.getPC(5));
        assertEquals("Wrong line number", 18, lnt.getPC(6));
        assertEquals("Wrong line number", 21, lnt.getPC(7));
        assertEquals("Wrong line number", 27, lnt.getPC(8));
        assertEquals("Wrong line number", 52, lnt.getPC(9));
        assertEquals("Wrong line number", 80, lnt.getPC(10));
        assertEquals("Wrong line number", 81, lnt.getPC(11));

        try {
            lnt.getPC(12);
            fail("Should have thrown NoSuchElementException");
        }
        catch(NoSuchElementException e) {
            // pass
        }
        catch(Throwable t) {
            fail("Should have thrown NoSuchElementException");
        }
    }
}
