package sysModel.classFile.constantPool;

import sysModel.classFile.constantPool.visitors.IPoolInfoVisitor;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Represents CONSTANT_Utf8_ASCII data in the constant pool.
 *
 * @author Mathias Ricken
 */
public class ASCIIPoolInfo extends AUTFPoolInfo {
    /**
     * Constructor
     *
     * @param s data
     */
    public ASCIIPoolInfo(String s, ConstantPool cp) {
        super(CONSTANT_Utf8_ASCII, s, cp);
    }

    /**
     * Constructor reading from a stream.
     *
     * @param dis input stream
     * @param cp  constant pool
     *
     * @throws IOException
     */
    public ASCIIPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(CONSTANT_Utf8_ASCII, dis, cp);
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toStringVerbose() {
        return "CONSTANT_Utf8_ASCII: String = " + _strValue;
    }

    /**
     * Compare this object and another one.
     *
     * @param obj other object
     *
     * @return true if the same
     */
    public boolean equals(Object obj) {
        return (obj instanceof ASCIIPoolInfo) &&
            (((ASCIIPoolInfo)obj)._strValue.equals(_strValue));
    }

    /**
     * Execute a visitor.
     *
     * @param visitor visitor
     * @param data    visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.asciizCase(this, data);
    }
}