package sysModel.classFile.constantPool;

import sysModel.classFile.constantPool.visitors.IPoolInfoVisitor;

import java.io.DataOutputStream;
import java.io.IOException;

/**
 * Represents an empty slot in the constant pool.
 *
 * @author Mathias Ricken
 */
public class EmptyPoolInfo extends APoolInfo {
    /**
     * Singleton constructor.
     */
    private EmptyPoolInfo() {
        super(-1, null);
    }

    /**
     * Singleton instance.
     */
    private static EmptyPoolInfo _instance = new EmptyPoolInfo();

    /**
     * Singleton accessor.
     *
     * @return singleton
     */
    public static EmptyPoolInfo singleton() {
        return _instance;
    }

    /**
     * Write this constant pool object into the stream, including the type byte.
     *
     * @param dos stream
     *
     * @throws IOException
     */
    public void write(DataOutputStream dos) throws IOException {
        // do nothing
    }

    /**
     * Resolve constant pool objects. This makes sure that the object links match the index links.
     */
    public void resolve() {
        // do nothing
    }

    /**
     * Reindex constant pool indices. This makes sure the index links match the object links.
     */
    public void reindex() {
        // do nothing
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toString() {
        return "Empty constant pool info";
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toStringVerbose() {
        return toString();
    }

    /**
     * Return a hash code.
     *
     * @return hash code
     */
    public int hashCode() {
        return 0;
    }

    /**
     * Compare this object and another one.
     *
     * @param obj other object
     *
     * @return true if the same
     */
    public boolean equals(Object obj) {
        return obj instanceof EmptyPoolInfo;
    }

    /**
     * Execute a visitor.
     *
     * @param visitor visitor
     * @param data    visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.emptyCase(this, data);
    }
}