package sysModel.classFile.constantPool;

import sysModel.classFile.constantPool.visitors.IPoolInfoVisitor;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Represents a field in the constant pool.
 *
 * @author Mathias Ricken
 */
public class FieldPoolInfo extends AClassNameTypePoolInfo {
    /**
     * Constructor
     *
     * @param clas        class information
     * @param nameAndType NameAndType information
     */
    public FieldPoolInfo(ClassPoolInfo clas, NameAndTypePoolInfo nameAndType, ConstantPool cp) {
        super(CONSTANT_Fieldref, clas, nameAndType, cp);
    }

    /**
     * Constructor reading from a stream.
     *
     * @param dis input stream
     * @param cp  constant pool
     *
     * @throws IOException
     */
    public FieldPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(CONSTANT_Fieldref, dis, cp);
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toString() {
        StringBuffer s;

        s = new StringBuffer();
        s.append("FIELD: Class = #");
        s.append(_classInfoIndex);
        s.append(", Name and type = #");
        s.append(_nameAndTypeIndex);

        return s.toString();
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toStringVerbose() {
        return toString();
    }

    /**
     * Compare this object and another one.
     *
     * @param obj other object
     *
     * @return true if the same
     */
    public boolean equals(Object obj) {
        return (obj instanceof FieldPoolInfo) && (
            (((FieldPoolInfo)obj)._classInfoIndex == _classInfoIndex) ||
            (((FieldPoolInfo)obj)._classInfo == _classInfo)
            ) && (
            (((FieldPoolInfo)obj)._nameAndTypeIndex == _nameAndTypeIndex) ||
            (((FieldPoolInfo)obj)._nameAndType == _nameAndType)
            );
    }

    /**
     * Execute a visitor.
     *
     * @param visitor visitor
     * @param data    visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.fieldCase(this, data);
    }
}