package sysModel.classFile.constantPool;

import sysModel.classFile.constantPool.visitors.IPoolInfoVisitor;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Represents a method in the constant pool.
 *
 * @author Mathias Ricken
 */
public class InterfaceMethodPoolInfo extends AClassNameTypePoolInfo {
    /**
     * Constructor
     *
     * @param clas        class information
     * @param nameAndType NameAndType information
     */
    public InterfaceMethodPoolInfo(ClassPoolInfo clas, NameAndTypePoolInfo nameAndType, ConstantPool cp) {
        super(CONSTANT_InterfaceMethodref, clas, nameAndType, cp);
    }

    /**
     * Constructor reading from a stream.
     *
     * @param dis input stream
     * @param cp  constant pool
     *
     * @throws IOException
     */
    public InterfaceMethodPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(CONSTANT_InterfaceMethodref, dis, cp);
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toString() {
        StringBuffer s;

        s = new StringBuffer();
        s.append("CONSTANT_InterfaceMethodref METHOD: Class = #");
        s.append(_classInfoIndex);
        s.append(", Name and type = #");
        s.append(_nameAndTypeIndex);

        return s.toString();
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toStringVerbose() {
        return toString();
    }

    /**
     * Compare this object and another one.
     *
     * @param obj other object
     *
     * @return true if the same
     */
    public boolean equals(Object obj) {
        return (obj instanceof InterfaceMethodPoolInfo) && (
            (((InterfaceMethodPoolInfo)obj)._classInfoIndex == _classInfoIndex) ||
            (((InterfaceMethodPoolInfo)obj)._classInfo == _classInfo)
            ) && (
            (((InterfaceMethodPoolInfo)obj)._nameAndTypeIndex == _nameAndTypeIndex) ||
            (((InterfaceMethodPoolInfo)obj)._nameAndType == _nameAndType)
            );
    }

    /**
     * Execute a visitor.
     *
     * @param visitor visitor
     * @param data    visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.interfaceMethodCase(this, data);
    }
}