package sysModel.classFile.constantPool;

import sysModel.classFile.constantPool.visitors.IPoolInfoVisitor;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Represents a method in the constant pool.
 *
 * @author Mathias Ricken
 */
public class MethodPoolInfo extends AClassNameTypePoolInfo {
    /**
     * Constructor
     *
     * @param clas        class information
     * @param nameAndType NameAndType information
     */
    public MethodPoolInfo(ClassPoolInfo clas, NameAndTypePoolInfo nameAndType, ConstantPool cp) {
        super(CONSTANT_Methodref, clas, nameAndType, cp);
    }

    /**
     * Constructor reading from a stream.
     *
     * @param dis input stream
     * @param cp  constant pool
     *
     * @throws IOException
     */
    public MethodPoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(CONSTANT_Methodref, dis, cp);
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toString() {
        StringBuffer s;

        s = new StringBuffer();
        s.append("METHOD: Class = #");
        s.append(_classInfoIndex);
        s.append(", Name and type = #");
        s.append(_nameAndTypeIndex);

        return s.toString();
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toStringVerbose() {
        return toString();
    }

    /**
     * Compare this object and another one.
     *
     * @param obj other object
     *
     * @return true if the same
     */
    public boolean equals(Object obj) {
        return (obj instanceof MethodPoolInfo) && (
            (((MethodPoolInfo)obj)._classInfoIndex == _classInfoIndex) ||
            (((MethodPoolInfo)obj)._classInfo == _classInfo)
            ) && (
            (((MethodPoolInfo)obj)._nameAndTypeIndex == _nameAndTypeIndex) ||
            (((MethodPoolInfo)obj)._nameAndType == _nameAndType)
            );
    }

    /**
     * Execute a visitor.
     *
     * @param visitor visitor
     * @param data    visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.methodCase(this, data);
    }
}