package sysModel.classFile.constantPool;

import sysModel.classFile.constantPool.visitors.IPoolInfoVisitor;

import java.io.DataInputStream;
import java.io.IOException;

/**
 * Represents Unicode data in the constant pool.
 *
 * @author Mathias Ricken
 */
public class UnicodePoolInfo extends AUTFPoolInfo {
    /**
     * Constructor.
     *
     * @param s data
     */
    public UnicodePoolInfo(String s, ConstantPool cp) {
        super(CONSTANT_Utf8_Unicode, s, cp);
    }

    /**
     * Constructor reading from a stream.
     *
     * @param dis input stream
     * @param cp  constant pool
     *
     * @throws IOException
     */
    public UnicodePoolInfo(DataInputStream dis, ConstantPool cp) throws IOException {
        super(CONSTANT_Utf8_Unicode, dis, cp);
    }

    /**
     * Return a human-readable version of this constant pool object.
     *
     * @return string
     */
    public String toStringVerbose() {
        return "CONSTANT_Utf8_Unicode: String = " + _strValue;
    }

    /**
     * Compare this object and another one.
     *
     * @param obj other object
     *
     * @return true if the same
     */
    public boolean equals(Object obj) {
        return (obj instanceof UnicodePoolInfo) &&
            (((UnicodePoolInfo)obj)._strValue.equals(_strValue));
    }

    /**
     * Execute a visitor.
     *
     * @param visitor visitor
     * @param data    visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    public <R, D> R execute(IPoolInfoVisitor<R, D> visitor, D data) {
        return visitor.unicodeCase(this, data);
    }
}