package sysModel.classFile.constantPool.visitors;

import sysModel.classFile.constantPool.APoolInfo;
import sysModel.classFile.constantPool.ClassPoolInfo;

/**
 * Check that the host is a class info.
 *
 * @author Mathias Ricken
 */
public class CheckClassVisitor extends ADefaultPoolInfoVisitor<ClassPoolInfo, Object> {
    /**
     * Singleton constructor.
     */
    private CheckClassVisitor() {
    }

    /**
     * Singleton instance.
     */
    private static CheckClassVisitor _instance = new CheckClassVisitor();

    /**
     * Singleton accessor.
     *
     * @return singleton
     */
    public static CheckClassVisitor singleton() {
        return _instance;
    }

    /**
     * All other cases throw.
     *
     * @param host non-class host
     * @param o    not used
     *
     * @return nothing
     */
    public ClassPoolInfo defaultCase(APoolInfo host, Object o) {
        throw new ClassFormatError("Info is of type " + host.getClass().getName() + ", needs to be ClassPoolInfo");
    }

    /**
     * Return host.
     *
     * @param host class host
     * @param o    not used
     *
     * @return host
     */
    public ClassPoolInfo classCase(ClassPoolInfo host, Object o) {
        return host;
    }
}
