package sysModel.classFile.constantPool.visitors;

import sysModel.classFile.constantPool.APoolInfo;
import sysModel.classFile.constantPool.MethodPoolInfo;

/**
 * Check that the host is a method info.
 *
 * @author Mathias Ricken
 */
public class CheckMethodVisitor extends ADefaultPoolInfoVisitor<MethodPoolInfo, Object> {
    /**
     * Singleton constructor.
     */
    private CheckMethodVisitor() {
    }

    /**
     * Singleton instance.
     */
    private static CheckMethodVisitor _instance = new CheckMethodVisitor();

    /**
     * Singleton accessor.
     *
     * @return singleton
     */
    public static CheckMethodVisitor singleton() {
        return _instance;
    }

    /**
     * All other cases throw.
     *
     * @param host non-class host
     * @param o    not used
     *
     * @return nothing
     */
    public MethodPoolInfo defaultCase(APoolInfo host, Object o) {
        throw new ClassFormatError("Info is of type " + host.getClass().getName() + ", needs to be Method");
    }

    /**
     * Case for method info.
     *
     * @param host method info
     * @param o    not used
     *
     * @return visitor-specific return value
     */
    public MethodPoolInfo methodCase(MethodPoolInfo host, Object o) {
        return host;
    }
}
