package sysModel.classFile.constantPool.visitors;

import sysModel.classFile.constantPool.APoolInfo;
import sysModel.classFile.constantPool.NameAndTypePoolInfo;

/**
 * Check that the host is a name-and-type info.
 *
 * @author Mathias Ricken
 */
public class CheckNameAndTypeVisitor extends ADefaultPoolInfoVisitor<NameAndTypePoolInfo, Object> {
    /**
     * Singleton constructor.
     */
    private CheckNameAndTypeVisitor() {
    }

    /**
     * Singleton instance.
     */
    private static CheckNameAndTypeVisitor _instance = new CheckNameAndTypeVisitor();

    /**
     * Singleton accessor.
     *
     * @return singleton
     */
    public static CheckNameAndTypeVisitor singleton() {
        return _instance;
    }

    /**
     * All other cases throw.
     *
     * @param host non-class host
     * @param o    not used
     *
     * @return nothing
     */
    public NameAndTypePoolInfo defaultCase(APoolInfo host, Object o) {
        throw new ClassFormatError("Info is of type " + host.getClass().getName() + ", needs to be NameAndType");
    }

    /**
     * Case for name and type info.
     *
     * @param host name and type info
     * @param o    not used
     *
     * @return visitor-specific return value
     */
    public NameAndTypePoolInfo nameAndTypeCase(NameAndTypePoolInfo host, Object o) {
        return host;
    }
}
