package sysModel.classFile.constantPool.visitors;

import sysModel.classFile.constantPool.APoolInfo;
import sysModel.classFile.constantPool.ASCIIPoolInfo;
import sysModel.classFile.constantPool.AUTFPoolInfo;
import sysModel.classFile.constantPool.UnicodePoolInfo;

/**
 * Check that the host is a UTF info.
 *
 * @author Mathias Ricken
 */
public class CheckUTFVisitor extends ADefaultPoolInfoVisitor<AUTFPoolInfo, Object> {
    /**
     * Singleton constructor.
     */
    private CheckUTFVisitor() {
    }

    /**
     * Singleton instance.
     */
    private static CheckUTFVisitor _instance = new CheckUTFVisitor();

    /**
     * Singleton accessor.
     *
     * @return singleton
     */
    public static CheckUTFVisitor singleton() {
        return _instance;
    }

    /**
     * All other cases throw.
     *
     * @param host non-UTF host
     * @param o    not used
     *
     * @return nothing
     */
    public AUTFPoolInfo defaultCase(APoolInfo host, Object o) {
        throw new ClassFormatError("Info is of type " + host.getClass().getName() + ", needs to be AUTFPoolInfo");
    }

    /**
     * Return host.
     *
     * @param host UTF host
     * @param o    not used
     *
     * @return host
     */
    public AUTFPoolInfo asciizCase(ASCIIPoolInfo host, Object o) {
        return host;
    }

    /**
     * Return host.
     *
     * @param host UTF host
     * @param o    not used
     *
     * @return host
     */
    public AUTFPoolInfo unicodeCase(UnicodePoolInfo host, Object o) {
        return host;
    }
}
