package sysModel.classFile.constantPool.visitors;

import sysModel.classFile.constantPool.APoolInfo;
import sysModel.classFile.constantPool.DoublePoolInfo;
import sysModel.classFile.constantPool.LongPoolInfo;

/**
 * Return the size of the info in the constant pool. Double and long use two entries, all others use one.
 *
 * @author Mathias Ricken
 */
public class GetPoolInfoSizeVisitor extends ADefaultPoolInfoVisitor<Integer, Object> {
    /**
     * Singleton constructor.
     */
    private GetPoolInfoSizeVisitor() {
    }

    /**
     * Singleton instance.
     */
    private static GetPoolInfoSizeVisitor _instance = new GetPoolInfoSizeVisitor();

    /**
     * Singleton accessor.
     *
     * @return singleton
     */
    public static GetPoolInfoSizeVisitor singleton() {
        return _instance;
    }

    /**
     * All other cases return 1.
     *
     * @param host one-slot host
     * @param o    not used
     *
     * @return 1
     */
    public Integer defaultCase(APoolInfo host, Object o) {
        return new Integer(1);
    }

    /**
     * Returns 2
     *
     * @param host long info
     * @param o    not used
     *
     * @return 2
     */
    public Integer longCase(LongPoolInfo host, Object o) {
        return new Integer(2);
    }

    /**
     * Returns 2.
     *
     * @param host double info
     * @param o    not used
     *
     * @return 2
     */
    public Integer doubleCase(DoublePoolInfo host, Object o) {
        return new Integer(2);
    }
}
