package sysModel.classFile.constantPool.visitors;

import sysModel.classFile.constantPool.*;

/**
 * Visitor on constant pool info objects. First generic type parameter is return type, second is parameter type.
 *
 * @author Mathias Ricken
 */
public interface IPoolInfoVisitor <R, D> {
    /**
     * Case for empty info.
     *
     * @param host  empty info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R emptyCase(EmptyPoolInfo host, D param);

    /**
     * Case for class info.
     *
     * @param host  class info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R classCase(ClassPoolInfo host, D param);

    /**
     * Case for string info.
     *
     * @param host  string info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R stringCase(StringPoolInfo host, D param);

    /**
     * Case for field info.
     *
     * @param host  field info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R fieldCase(FieldPoolInfo host, D param);

    /**
     * Case for method info.
     *
     * @param host  method info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R methodCase(MethodPoolInfo host, D param);

    /**
     * Case for interface method info.
     *
     * @param host  interface method info info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R interfaceMethodCase(InterfaceMethodPoolInfo host, D param);

    /**
     * Case for name and type info.
     *
     * @param host  name and type info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R nameAndTypeCase(NameAndTypePoolInfo host, D param);

    /**
     * Case for int info.
     *
     * @param host  int info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R intCase(IntegerPoolInfo host, D param);

    /**
     * Case for float info.
     *
     * @param host  float info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R floatCase(FloatPoolInfo host, D param);

    /**
     * Case for long info.
     *
     * @param host  long info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R longCase(LongPoolInfo host, D param);

    /**
     * Case for double info.
     *
     * @param host  double info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R doubleCase(DoublePoolInfo host, D param);

    /**
     * Case for asciiz info.
     *
     * @param host  asciiz info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R asciizCase(ASCIIPoolInfo host, D param);

    /**
     * Case for unicode info.
     *
     * @param host  unicode info
     * @param param visitor-specific parameter
     *
     * @return visitor-specific return value
     */
    R unicodeCase(UnicodePoolInfo host, D param);
}
