package sysModel.classFile.constantPool.visitors;

import sysModel.classFile.constantPool.APoolInfo;

/**
 * Abstract visitor in which all cases call a default method.
 *
 * @author Mathias Ricken
 */
public class NoOpPoolInfoVisitor <R, D> extends ADefaultPoolInfoVisitor<R, D> {
    /**
     * No operation default case.
     *
     * @param host  constant pool info item
     * @param param visitor-specific parameter
     *
     * @return returns null
     */
    public R defaultCase(APoolInfo host, D param) {
        // do nothing
        return null;
    }
}
