package sysModel.env;

import model.ILambda;
import sysModel.NoOpLambda;

/**
 * Decorator for a lambda to make it deactivatable.
 *
 * @author Mathias G. Ricken
 */
public class DeactivatableLambda implements ILambda {
    /**
     * Decorated command.
     */
    private ILambda _decoree;

    /**
     * Execute the wrapped command only if action is activated.
     *
     * @param param parameter for the decoree
     * @return return value of the decoree
     */
    public Object apply(Object param) {
        return _decoree.apply(param);
    }

    /**
     * Deactivate action.
     */
    public void deactivate() {
        _decoree = NoOpLambda.instance();
    }

    /**
     * Make a new deactivatable command.
     *
     * @param wrapped command to make deactivatable
     */
    public DeactivatableLambda(ILambda wrapped) {
        _decoree = wrapped;
    }
}
