package sysModel.env;

import sysModel.fish.AFish;

/**
 * Class containing parameters that the fish passes back to the lambda on an update.
 *
 * @author Mathias Ricken
 */
public class FishApplyParams {
    /// the fish being passed back
    private AFish _fish;
    /// the fish's local environment
    private AGlobalEnv.ALocalEnv _localEnv;

    /**
     * Construct new parameters.
     *
     * @param f  fish
     * @param le local environment
     */
    public FishApplyParams(AFish f, AGlobalEnv.ALocalEnv le) {
        _fish = f;
        _localEnv = le;
    }

    /**
     * Get the fish.
     *
     * @return fish
     */
    public AFish fish() {
        return _fish;
    }

    /**
     * Get the local environment.
     *
     * @return local environment
     */
    public AGlobalEnv.ALocalEnv localEnv() {
        return _localEnv;
    }

    /**
     * Return the string representation of the fish-local environment pair.
     *
     * @return string representation
     */
    public String toString() {
        return _fish.getClass().getName() + ' ' + _localEnv;
    }
}
