package sysModel.env;

/**
 * Local environment state.
 *
 * @author Mathias Ricken
 */
public interface ILocalEnvState {
    /**
     * Execute a visitor on local environment, depending on the state.
     *
     * @param host    host local environment
     * @param visitor visitor to execute
     * @param param   visitor-specific parameter
     * @return visitor-specific return value
     */
    public Object execute(AGlobalEnv.ALocalEnv host, AGlobalEnv.ILocalEnvVisitor visitor, Object param);
}
