package sysModel.env.tests;

import controller.IScrollAdapter;
import junit.framework.TestCase;
import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.ISecurityAdapter;
import sysModel.fish.AFish;
import sysModel.env.AEnvFactory;
import sysModel.env.AGlobalEnv;
import sysModel.env.ASquareEnv;
import sysModel.parser.Lexer;

import java.awt.*;
import java.awt.geom.Point2D;
import java.io.PrintWriter;

/**
 * Test cases for ASquareEnv.Direction.
 *
 * @author Mathias Ricken
 */
public class Test_ASquareEnv_Direction extends TestCase {
    private ICmdFactory _cmdFactory;
    private ISecurityAdapter _sm;
    private ASquareEnv _env;

    private static final ILambda _notify = new ILambda() {
        public Object apply(Object param) {
            return "notifyCmd";
        }
    };
    private static final ILambda _delete = new ILambda() {
        public Object apply(Object param) {
            return "deleteCmd";
        }
    };
    private static final ILambda _add = new ILambda() {
        public Object apply(Object param) {
            return "addCmd";
        }
    };

    public void setUp() throws Exception {
        super.setUp();
        _cmdFactory = new ICmdFactory() {
            public ILambda makeNotifyCmd(ILambda lambda) {
                return _notify;
            }

            public ILambda makeDeleteCmd(AGlobalEnv.ALocalEnv env) {
                return _delete;
            }

            public ILambda makeAddCmd(AFish fish) {
                return _add;
            }
        };
        _sm = new ISecurityAdapter() {
            public void setProtected(boolean _protected) {
            }
            public ThreadGroup getFishThreadGroup() {
                return null;
            }
            public ClassLoader getClassLoader() {
                return null;
            }
            public void handleException(Throwable t) {
            }
        };

        _env = new ASquareEnv(_cmdFactory, _sm) {
            protected void addFishToInternalData(ALocalEnv localEnv, AFish fish) {
            }

            protected ASquareEnv.ASquareLocalEnvironment makeLocalEnv(ASquareEnv.Location loc,
                                                                      ASquareEnv.Direction dir) {
                return null;
            }

            protected AGlobalEnv parseEnvironment(Lexer l) {
                return null;
            }

            public AEnvFactory makeEnvFactory() {
                return null;
            }

            protected void printHeader(PrintWriter pw) {
            }

            public Dimension getDisplaySize() {
                return null;
            }

            public void returnHome(IScrollAdapter sa) {
            }

            public Point2D.Double getViewPosition(Point2D.Double pos) {
                return null;
            }

            public Point2D.Double getPanDelta(Point2D.Double delta) {
                return null;
            }

            protected void removeFishFromInternalData(ALocalEnv localEnv) {
            }
        };
    }

    /**
     * Test getters and ctors.
     */
    public void testGetSet() {
        ASquareEnv.Direction d = _env.makeDirection();
        assertEquals(0.0, d.getDeltaX(), 0.01);
        assertEquals(-1.0, d.getDeltaY(), 0.01);

        d = _env.makeDirection(-0.5, 0.5);
        assertEquals(-0.5, d.getDeltaX(), 0.01);
        assertEquals(0.5, d.getDeltaY(), 0.01);

        ASquareEnv.Direction d2 = _env.makeDirection(d);
        assertEquals(-0.5, d2.getDeltaX(), 0.01);
        assertEquals(0.5, d2.getDeltaY(), 0.01);
    }

    /**
     * Test turning.
     */
    public void testTurn() {
        ASquareEnv.Direction d = _env.makeDirection();
        d.turnRight();
        assertEquals(1.0, d.getDeltaX(), 0.01);
        assertEquals(0.0, d.getDeltaY(), 0.01);

        d.turnRight(Math.PI / 2);
        assertEquals(0.0, d.getDeltaX(), 0.01);
        assertEquals(1.0, d.getDeltaY(), 0.01);

        d.turnLeft(-Math.PI);
        assertEquals(0.0, d.getDeltaX(), 0.01);
        assertEquals(-1.0, d.getDeltaY(), 0.01);

        d.turnLeft();
        assertEquals(-1.0, d.getDeltaX(), 0.01);
        assertEquals(0.0, d.getDeltaY(), 0.01);
    }

    /**
     * Test reverse.
     */
    public void testReverse() {
        ASquareEnv.Direction d = _env.makeDirection(1, -1);
        d.reverseDirection();
        assertEquals(-1.0, d.getDeltaX(), 0.01);
        assertEquals(1.0, d.getDeltaY(), 0.01);
        d.reverseDirection();
        assertEquals(1.0, d.getDeltaX(), 0.01);
        assertEquals(-1.0, d.getDeltaY(), 0.01);
    }

    /**
     * Test same.
     */
    public void testSame() {
        ASquareEnv.Direction d = _env.makeDirection(1, -1);
        ASquareEnv.Direction d1 = _env.makeDirection(1, -1);
        ASquareEnv.Direction d2 = _env.makeDirection(1, 2);
        assertEquals(true, d.same(d1));
        assertEquals(false, d.same(d2));
        assertEquals(true, d1.same(d));
        assertEquals(false, d2.same(d));
        assertEquals(false, d2.same(d1));
        assertEquals(false, d1.same(d2));
    }

    /**
     * Test angle.
     */
    public void testAngle() {
        ASquareEnv.Direction d = _env.makeDirection();
        assertEquals(0.0 / 180 * Math.PI, d.getAngle(), 0.01);
        d.turnRight();
        assertEquals(90.0 / 180 * Math.PI, d.getAngle(), 0.01);

        d.turnRight(Math.PI / 2);
        assertEquals(180.0 / 180 * Math.PI, d.getAngle(), 0.01);

        d.turnLeft(-Math.PI);
        assertEquals(0.0 / 180 * Math.PI, d.getAngle(), 0.01);

        d.turnLeft();
        assertEquals(270.0 / 180 * Math.PI, d.getAngle(), 0.01);
    }

}
