package sysModel.env.tests;

import controller.IScrollAdapter;
import junit.framework.TestCase;
import model.ILambda;
import sysModel.ICmdFactory;
import sysModel.ISecurityAdapter;
import sysModel.fish.AFish;
import sysModel.env.AEnvFactory;
import sysModel.env.AGlobalEnv;
import sysModel.env.ASquareEnv;
import sysModel.parser.Lexer;

import java.awt.*;
import java.awt.geom.Point2D;
import java.io.PrintWriter;

/**
 * Test cases for ASquareEnv.Location.
 *
 * @author Mathias Ricken
 */
public class Test_ASquareEnv_Location extends TestCase {
    private ICmdFactory _cmdFactory;
    private ISecurityAdapter _sm;
    private ASquareEnv _env;

    private static final ILambda _notify = new ILambda() {
        public Object apply(Object param) {
            return "notifyCmd";
        }
    };
    private static final ILambda _delete = new ILambda() {
        public Object apply(Object param) {
            return "deleteCmd";
        }
    };
    private static final ILambda _add = new ILambda() {
        public Object apply(Object param) {
            return "addCmd";
        }
    };

    public void setUp() throws Exception {
        super.setUp();
        _cmdFactory = new ICmdFactory() {
            public ILambda makeNotifyCmd(ILambda lambda) {
                return _notify;
            }

            public ILambda makeDeleteCmd(AGlobalEnv.ALocalEnv env) {
                return _delete;
            }

            public ILambda makeAddCmd(AFish fish) {
                return _add;
            }
        };
        _sm = new ISecurityAdapter() {
            public void setProtected(boolean _protected) {
            }
            public ThreadGroup getFishThreadGroup() {
                return null;
            }
            public ClassLoader getClassLoader() {
                return null;
            }
            public void handleException(Throwable t) {
            }
        };

        _env = new ASquareEnv(_cmdFactory, _sm) {
            protected void addFishToInternalData(ALocalEnv localEnv, AFish fish) {
            }

            protected ASquareEnv.ASquareLocalEnvironment makeLocalEnv(ASquareEnv.Location loc,
                                                                      ASquareEnv.Direction dir) {
                return null;
            }

            protected AGlobalEnv parseEnvironment(Lexer l) {
                return null;
            }

            public AEnvFactory makeEnvFactory() {
                return null;
            }

            protected void printHeader(PrintWriter pw) {
            }

            public Dimension getDisplaySize() {
                return null;
            }

            public void returnHome(IScrollAdapter sa) {
            }

            public Point2D.Double getViewPosition(Point2D.Double pos) {
                return null;
            }

            public Point2D.Double getPanDelta(Point2D.Double delta) {
                return null;
            }

            protected void removeFishFromInternalData(ALocalEnv localEnv) {
            }
        };
    }

    /**
     * Test getters, setters, and ctor.
     */
    public void testGetSet() {
        ASquareEnv.Location l = _env.makeLocation(5, 7);
        assertEquals(5.0, l.getX(), 0.01);
        assertEquals(7.0, l.getY(), 0.01);

        l.setX(11);
        assertEquals(11.0, l.getX(), 0.01);
        assertEquals(7.0, l.getY(), 0.01);

        l.setY(13);
        assertEquals(11.0, l.getX(), 0.01);
        assertEquals(13.0, l.getY(), 0.01);
    }

    /**
     * Test same.
     */
    public void testSame() {
        ASquareEnv.Location l = _env.makeLocation(17, 23);
        ASquareEnv.Location l1 = _env.makeLocation(17, 23);
        ASquareEnv.Location l2 = _env.makeLocation(31, 37);
        assertEquals(true, l.same(l1));
        assertEquals(false, l.same(l2));
        assertEquals(true, l1.same(l));
        assertEquals(false, l2.same(l));
        assertEquals(false, l2.same(l1));
        assertEquals(false, l1.same(l2));
    }

    /**
     * Test inField.
     */
    public void testInField() {
        ASquareEnv.Location l = _env.makeLocation(17, 23);
        ASquareEnv.Location l1 = _env.makeLocation(17, 23);
        ASquareEnv.Location l2 = _env.makeLocation(17.13, 23.53);
        ASquareEnv.Location l3 = _env.makeLocation(17.49, 23.77);
        ASquareEnv.Location l4 = _env.makeLocation(31, 37);
        ASquareEnv.Location l5 = _env.makeLocation(31.81, 37.51);
        assertEquals(true, l.inField(l1));
        assertEquals(true, l1.inField(l));
        assertEquals(true, l.inField(l2));
        assertEquals(true, l2.inField(l));
        assertEquals(true, l.inField(l3));
        assertEquals(true, l3.inField(l));
        assertEquals(false, l.inField(l4));
        assertEquals(false, l4.inField(l));
        assertEquals(false, l.inField(l5));
        assertEquals(false, l5.inField(l));
    }

    /**
     * Test getNeighbor.
     */
    public void testNeighbor() {
        ASquareEnv.Location l = _env.makeLocation(17, 23);
        ASquareEnv.Location l1 = _env.makeLocation(17, 22);
        ASquareEnv.Location l2 = _env.makeLocation(18, 22);
        ASquareEnv.Location l3 = _env.makeLocation(18, 23);
        ASquareEnv.Location l4 = _env.makeLocation(17, 23);
        l = l.getNeighbor(_env.makeDirection(0, -1));
        assertEquals(true, l.same(l1));
        l = l.getNeighbor(_env.makeDirection(1, 0));
        assertEquals(true, l.same(l2));
        l = l.getNeighbor(_env.makeDirection(0, 1));
        assertEquals(true, l.same(l3));
        l = l.getNeighbor(_env.makeDirection(-1, 0));
        assertEquals(true, l.same(l4));
    }
}
