package sysModel.env.tests;

import model.ILambda;
import sysModel.env.DeactivatableLambda;
import junit.framework.TestCase;

/**
 * Test cases for DeactivatableLambda.
 *
 * @author Mathias Ricken
 */
public class Test_DeactivatableLambda extends TestCase {
    /**
     * Test not deactivating a lambda.
     */
    public void testDontDeactivate() {
        final String msg = "should be thrown";
        try {
            ILambda lambda = new ILambda() {
                /**
                 * Execute command.
                 */
                public Object apply(Object param) {
                    throw new RuntimeException(msg);
                }
            };
            DeactivatableLambda deactivatable = new DeactivatableLambda(lambda);
            deactivatable.apply(null);
            fail("Lambda was not executed.");
        }
        catch (RuntimeException e) {
            if (!e.getMessage().equals(msg)) {
                fail("Wrong exception thrown.");
            }
        }
    }

    /**
     * Test not deactivating a lambda.
     */
    public void testDontDeactivate2() {
        ILambda lambda = new ILambda() {
            /**
             * Execute command.
             */
            public Object apply(Object param) {
                try {
                    return new Integer(123 * ((Integer) param).intValue());
                }
                catch (Exception e) {
                    fail("Failed to cast parameter: " + e.toString());
                    return null;
                }
            }
        };
        DeactivatableLambda deactivatable = new DeactivatableLambda(lambda);
        try {
            Integer i = (Integer) deactivatable.apply(new Integer(33));
            if (33 * 123 != i.intValue()) {
                fail("Incorrect return value.");
            }
        }
        catch (Exception e) {
            fail("Failed to cast return value: " + e.toString());
        }
    }

    /**
     * Test deactivating a lambda.
     */
    public void testDeactivate() {
        ILambda lambda = new ILambda() {
            /**
             * Execute command.
             */
            public Object apply(Object param) {
                fail("Should not be executed.");
                return null;
            }
        };
        DeactivatableLambda deactivatable = new DeactivatableLambda(lambda);
        deactivatable.deactivate();
        deactivatable.apply(null);
    }
}
