package sysModel.fish;

import sysModel.ISecurityAdapter;

import java.awt.*;
import java.lang.reflect.Constructor;

/**
 * AFish factory to dynamically create new fish.
 *
 * @author Mathias Ricken
 */
public class DynamicFishFactory implements IFishFactory {
    /// current name of the fish class
    private String _curName;

    /// current color of the fish
    private Color _curColor;

    /// security adapter
    private ISecurityAdapter _securityAdapter;

    /**
     * Construct a new factory.
     *
     * @param name  initial name
     * @param color initial color
     * @param sa    security adapter
     */
    public DynamicFishFactory(String name, Color color, ISecurityAdapter sa) {
        _curName = name;
        _curColor = color;
        _securityAdapter = sa;
    }

    /**
     * Mutator for the name.
     *
     * @param newName new name
     */
    public void setName(String newName) {
        _curName = newName;
    }


    /**
     * Mutator for the color.
     *
     * @param newColor new color
     */
    public void setName(Color newColor) {
        _curColor = newColor;
    }

    /**
     * Create a new fish.
     *
     * @return new fish
     */
    public AFish createFish() {
        try {
            // NOTE: Introduced class loader here
            // Class fishClass = Class.forName(_curName);
            Class fishClass = _securityAdapter.getClassLoader().loadClass(_curName);
            Constructor envCtor = fishClass.getConstructor(new Class[]{Color.class});
            return (AFish) envCtor.newInstance(new Object[]{_curColor});
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading fish class", e);
        }
    }
}
